/***************************************************************************
                          kpldoubleedit.h  -  description
                             -------------------
    begin                : Tue Aug 15 2000
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLDOUBLEEDIT_H
#define KPLDOUBLEEDIT_H

#include <qlineedit.h>

class QDoubleValidator;

/**
  * Double value line edit class. Provides a QLineEdit widget with validator.
  * @author Werner Stille
  */
class KplDoubleEdit : public QLineEdit
{
public:
  /**
   * Constructor.
   * @param val initial double value.
   * @param minVal minimum value.
   * @param maxVal maximum value.
   * @param parent pointer to parent widget.
   * @param format format string for value display.
   */
	KplDoubleEdit(double val, double minVal, double maxVal, QWidget* parent,
                const char* format = "%.2lf");
  /** Destructor. */
	~KplDoubleEdit();
  /**
   * Fixups and returns value.
   * @return value.
   */
  double value();

protected:
  /** Reimplemented for fixup of text. */
  virtual void focusOutEvent(QFocusEvent*);
  QString frm;
  QDoubleValidator *validator;

  friend class FrameDlg;
};

#endif
