/***************************************************************************
                          psgraph.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Wed Sep 08 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PSGRAPH_H
#define PSGRAPH_H

#include <stdio.h>
#include "kplgraph.h"

/**
  * PostScript graphics class. Provides high level plotting functionality.
  * @author Werner Stille
  */

class PSGraph : public KplGraph  {

public:
  /** Constructor */
	PSGraph();
  /** Destructor */
	virtual ~PSGraph();
  /** Points per cm */
  static const double pts;
  /**
   * Initializes PostScript graphics.
   * @param f pointer to stream opened for write access.
   * @param xf width of bounding box.
   * @param yf height of bounding box.
   */
  void psInit(FILE* f, double xf, double yf);
  virtual void format(double x, double y);
  virtual void setColFrame(unsigned icol1);
  virtual void setColGrid(unsigned icol2);
  virtual void setColData(unsigned icol3);
  virtual void setCol(unsigned icol1, unsigned icol2, unsigned icol3);
  virtual double setRelSize(double r);
  virtual void Window(double x0, double xl, double y0, double yl);
  virtual void scale(double xl, double xr, double yu, double yo,
                     bool logx, bool logy);
  virtual void setDig(int nx, int ny);
  virtual void frame();
  virtual void raster(double xtic, double ytic, int intx, int inty, int mode);
  virtual void textcm(const char* str, double x, double y, int iorg);
  virtual void letH(const char* str);
  virtual void letX(const char* str, int iex);
  virtual void letY(const char* str, int iex);
  virtual void setSymbol(int is);
  virtual void plArray(const double* x, const double* y,
                       double fx, double fy, int n);
  virtual void plError(const double* x, const double* y, const double* e,
                       double fx, double fy, int n);
  /** Ends PostScript graphic and closes output stream. */
  void psExit();
  virtual void cm2r(double xcm, double ycm, double fxn, double fyn,
                    double* xr, double* yr) const;

protected:
  void psStr(const char* str);
  void text(const char* str, double x, double y, int iorg);
  double x0, xl, y0, yl, xmin, xmax, ymin, ymax;
  FILE* fps;
};

#endif
