/***************************************************************************
                          refreshdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REFRESHDLG_H
#define REFRESHDLG_H

#include <qdialog.h>

class QCheckBox;
class KplSpinBox;

/**
  * Load periodically dialog. Provides a dialog to setup periodically reloading.
  * @author Werner Stille
  */
class RefreshDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   */
  RefreshDlg(QWidget* parent);
  /** Destructor. */
  ~RefreshDlg();
  /**
   * Initializes widget contents.
   * @param tRef refresh interval in seconds.
   * @param act true for active.
   */
  void setWidgets(int tRef, bool act);
  /**
   * Reads widget contents.
   * @param tRef pointer to refresh interval (output).
   * @param act pointer to state (true for active, output).
   */
  void getValues(int* tRef, bool* act) const;

protected:
  KplSpinBox* dt;
  QCheckBox* activate;
};

#endif
