/***************************************************************************
                          arraydlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARRAYDLG_H
#define ARRAYDLG_H

#include <qdialog.h>

class QLineEdit;
class QLabel;
class QCheckBox;
class QPushButton;
class KURL;
class KColorButton;
class KplSpinBox;
class KplDoc;
class ArrayItem;
class KplDoubleEdit;

/**
  * Array settings dialog class. Provides a dialog for the settings
  * of an array plot item.
  * @author Werner Stille
  */
class ArrayDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ad pointer to array data structure.
   */
  ArrayDlg(QWidget* parent, KplDoc* model, ArrayItem* ad);
  /** Destructor. */
	~ArrayDlg();

protected:
  /**
   * Updates ranges of spin boxes.
   * @param ad pointer to array data structure.
   */
  void setSpinBoxes(ArrayItem* ad);
  /**
   * Loads file.
   * @return true when when succeeded.
   */
  bool load(KURL &url);
  /**
   * Copies settings to array data structure.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  ArrayItem *ad, *adt;
  KplDoubleEdit *efx, *efy;
  QLabel* fileName;
  KplSpinBox *ix, *iy, *ie, *iStart, *n, *symb;
  QCheckBox* err;
  KColorButton* colData;
  QPushButton* bReload;

protected slots:
  /** Adjusts the Number of points spinbox when start index is changed. */
  void slotStartChanged(int);
  /** Adjusts the Start index spinbox when number of points is changed. */
  void slotNChanged(int);
  /** Displays the dialog for selection of a data file. */
  void slotFile();
  /** Reloads file. */
  void slotReload();
  /** Applies settings and leaves the dialog. */
  void slotOK();
  /** Applies settings without leaving the dialog. */
  void slotApply();
  /** Displays help for the array dialog. */
  void slotHelp();
};

#endif
