/***************************************************************************
                          legenddlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include "kplspinbox.h"
#include "legenddlg.h"
#include "legenditem.h"
#include "kpldoc.h"
#include "edittextdlg.h"
#include "symboldlg.h"
#include "kpldoubleedit.h"

LegendDlg::LegendDlg(QWidget* parent, KplDoc* model, LegendItem* ld0) :
 QDialog(parent, 0, true), m(model), ld(ld0)
{
  resize(400, 250);
  setCaption(i18n("Legend"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Data"), this);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 2, 7, 6);
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(ld->symb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  grid->addWidget(bSymb, 0, 2);
  bSymb->setFixedWidth(50);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel(i18n("Color"), g), 0, 4);
  grid->addWidget(colSymb = new KColorButton(ld->color, g), 0, 5);
  grid->addWidget(new QLabel("x", g), 1, 0);
  grid->addWidget(ex0 = new KplDoubleEdit(ld->x0, -200.0, 200.0, g), 1, 1);
  grid->addWidget(new QLabel("cm", g), 1, 2);
  grid->addWidget(new QLabel("y", g), 1, 4);
  grid->addWidget(ey0 = new KplDoubleEdit(ld->y0, -200.0, 200.0, g), 1, 5);
  grid->addWidget(new QLabel("cm", g), 1, 6);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Label"), this));
  grid = new QGridLayout(g->layout(), 3, 7, 6);
  grid->addWidget(new QLabel(i18n("Text"), g), 0, 0);
  grid->addMultiCellWidget(eText = new QLineEdit(ld->s, g), 0, 0, 1, 5);
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  grid->addWidget(b, 0, 6);
  connect(b, SIGNAL(clicked()), SLOT(slotEditText()));
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * ld->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), g), 1, 4);
  grid->addWidget(colText = new KColorButton(ld->coltext, g), 1, 5);
  grid->addWidget(new QLabel("xoff", g), 2, 0);
  grid->addWidget(exl = new KplDoubleEdit(ld->xtext, -200.0, 200.0, g), 2, 1);
  grid->addWidget(new QLabel("cm", g), 2, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 2, 3);
  grid->addWidget(new QLabel("yoff", g), 2, 4);
  grid->addWidget(eyl = new KplDoubleEdit(ld->ytext, -200.0, 200.0, g), 2, 5);
  grid->addWidget(new QLabel("cm", g), 2, 6);
  QHBoxLayout* hbox = new QHBoxLayout(vbox);
  hbox->addWidget(b = new QPushButton(i18n("Help"), this));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  connect(b, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addWidget(b = new QPushButton(i18n("OK"), this));
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(b = new QPushButton(i18n("Apply"), this));
  connect(b, SIGNAL(clicked()), SLOT(slotApply()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

LegendDlg::~LegendDlg()
{
}

void LegendDlg::getValues(bool ok)
{
  ld->setPos(ex0->value(), ey0->value());
  ld->xtext = exl->value();
  ld->ytext = eyl->value();
  ld->color = colSymb->color().rgb();
  ld->coltext = colText->color().rgb();
  ld->symb = symb->interpretedValue();
  ld->relsiz = 0.01 * eRelSize->interpretedValue();
  ld->s = eText->text();
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}

void LegendDlg::slotEditText()
{
  EditTextDlg dlg(this, eText);
  dlg.exec();
}

void LegendDlg::slotOK()
{
  getValues(true);
}

void LegendDlg::slotApply()
{
  getValues(false);
}

void LegendDlg::slotHelp()
{
  kapp->invokeHelp("SEC-LEGEND");
}
