/***************************************************************************
                          ksteak.cpp  -  description
                             -------------------
    begin                : Thu Nov 14 09:16:56 CEST 2000
    copyright            : (C) 2000, 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksteak.h"
#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qcursor.h>
#include <qregexp.h>
#include <klocale.h>

/**************************************************
 * constructor					  *
 **************************************************/
Ksteak::Ksteak(QWidget *parent, const char *name) : QWidget(parent, name)
{
  English = FALSE;
  German = FALSE;
  Context = FALSE;
  Sensitive = FALSE;
  SearchAnd = FALSE;
  SearchOr = FALSE;
  docked = FALSE;

  ViewSteak = new QTextView(this);
  ViewSteak->setPaper(QBrush::QBrush(QColor(255, 255, 200)));

  LabelSearch = new QLabel(i18n("Search"), this);
  LineSearch = new KComboBox(TRUE, this);
  connect(LineSearch, SIGNAL(activated(int)), this, SLOT(slotTrans(int)));
}

/**************************************************
 * destructor                                     *
 **************************************************/
Ksteak::~Ksteak()
{
}

/*************************************************
 * function to call getTranslations from toolbar *
 *************************************************/
void Ksteak::slotTrans(int)
{
  getTranslation(ViewSteak);
}

/**************************************************
 * call steak + get translation from stdout       *
 **************************************************/
void Ksteak::getTranslation(QTextView *view)
{
  FILE *fp;
  QString command;
  QString sline;//(1024);	
  char line[1024];
  
  unsigned int MaxLength=0;
  Row = 1;

  //clear QTextView
  view->setText("");
  //set clock-cursor
  KApplication::setOverrideCursor(waitCursor);
	
  //Befehl zusammensetzen
  command="steak -nowait";
  if (English & German) 
	command.append(" -de");
  else if (German) 
	command.append(" -d");
  else if (English) 
	command.append(" -e");
  if ((!Context) || (docked)) 
	command.append(" -k");
  if (Sensitive) 
	command.append(" -noignor");
  if (SearchAnd) 
	command.append(" -and");
  if (SearchOr) 
	command.append(" -or");
  command.append(" ");

  //Eingabe an Befehl haengen
  if (!docked) {
    command.append(LineSearch->currentText());
  }
	
  //ausfuehren
  if ((fp = popen(command, "r")) == NULL) {
	fprintf(stderr, "popen error");
	exit(1);
  }

  while ((fgets(line, 1024, fp)) != NULL)
    {
      sline = line;	
      sline=sline.stripWhiteSpace();
      //haessliche Zeilen rausfiltern
      sline.replace( QRegExp("^\\d+\\s*)\\s*"), ""); //remove numbers at the begin of line
      
      // string match for :== 
      int i = sline.find(":==");
      if (i>=0) {
	sline.insert(0, "<B>");
	sline.remove(i+2, 4);
	sline.insert(i+2, "</B><BR> &nbsp; &nbsp; ");
	i+=24;
	if (sline.length()-i > MaxLength) {
	  Max=sline.right(sline.length()-i);
	  MaxLength=sline.length()-i;
	}
	Row+=2;
	view->append(sline);
      }
      // andere strings pruefen
      else {
	if (!sline.contains("-", TRUE)) {
	  if (sline.length() > MaxLength) {    // andere strings pruefen
	    Max=sline.right(sline.length());
	    MaxLength=sline.length();
	  }
	  Row++;  
	  view->append(sline);
	}
      }
      if (sline.contains("--- Jetzt die Kontext", TRUE)) {
	view->append("<BR><B><U>"+i18n("Context")+"</U></B><BR>");
	Row++;
      }
    }
  if (ferror(fp)) printf("fgets error");
  pclose(fp);
  //restore cursor
  KApplication::restoreOverrideCursor();
}

/**********************************************
 * auf Aenderung der Fenstergroesse reagieren *
 **********************************************/
void Ksteak::resizeEvent(QResizeEvent *)
{
  LabelSearch->setGeometry(10,10,60,30);
  LineSearch->setGeometry(80,10,width()-90,30);
  ViewSteak->setGeometry(5,50,width()-10,height()-60);
}
