/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Fri Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dockwidget.h"
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
#include <stdio.h>

/*************************************************
 * create dockwidget with popup-menu             *
 *************************************************/
dockwidget::dockwidget(QWidget *, const char * name) : KSystemTray(0, name)
{
  myview = 0;
  mypop = 0;

  popup_menu = new KPopupMenu(this);
  popup_menu->setTitle("KSteak");
  popup_menu->insertItem(i18n("Undock"), 1);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("configure"), i18n("Configure KSteak"), 2);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("exit.png"), i18n("Quit"), 3);
  connect(popup_menu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));
}

/*************************************************
 * destructor                                    *
 *************************************************/
dockwidget::~dockwidget()
{
  delete popup_menu;
  delete mypop;
  delete myview;
}

/*************************************************
 * exec popup-menu on mousepressevent            *
 *************************************************/
void dockwidget::mousePressEvent(QMouseEvent* e)
{
  if (e->button() == RightButton) popup_menu->exec(QCursor::pos());
  if (e->button() == LeftButton) getTranslation(QString());
}

/*************************************************
 * emit signals when (un-)dock                   *
 *************************************************/
void dockwidget::slotMenuClicked(int i)
{
  if (i == 1) emit undock();
  if (i == 2) emit configure();
  if (i == 3) emit done();
}

void dockwidget::getTranslation(const QString & szWord)
{
  int x = QCursor::pos().x();
  int y = QCursor::pos().y();
  
  if (myview) delete myview; 
  if (mypop) delete mypop;

  //create Popup-window
  mypop = new KPopupFrame(this);
  //we dont need decorations
  mypop->setFrameStyle(QFrame::Box | QFrame::Plain);
  mypop->setLineWidth(2); //black frame
  // TextView
  myview = new QTextView(mypop);
  myview->setFrameStyle(QFrame::NoFrame);
  
  emit translate( szWord );

  int w = myview->width();
  int h = myview->height();

  //clever placement
  if (x-w < 1) w = 0;
  if (y-h < 1) h = 0;

  mypop->setMainWidget( myview );
  mypop->popup( QPoint(x-w, y-h) );
}
