/***************************************************************************
 *   Copyright (C) 2000 2008 by Michael Rapaport   *
 *   rucko4t@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "draughtview.h"
#include "masq.h"
#include "tred.h"
#include "game.h"
#include <qpainter.h>
#include <qimage.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include <kapplication.h>
#include <qdatastream.h>
#include <qfile.h>
#include <kaudioplayer.h>


extern QImage mana_fn,kinga_fn,manb_fn,kingb_fn,boardd_fn;
extern int half_inc;
extern draughtView *pFig;
extern Game *mike;
extern int infinitie;    ///dep,    dep is always set in play_it now so all is ignored except for killing thread
extern float score[2];
extern QString ssnd;
int numGames;
int alreadyDrawn,num_moves_no_cap_or_man_move;
char tmptype;
Hash hash[64];
QString str = "klaat";
QString top;
QString bot;
QString space="         ";
QString dra;
QString gmsplayd;
extern int wth;
extern const uint64_t mask[64];
uint64_t sigeMK;
QMutex playing;
QSemaphore mkmove(1);
playThread claat;
trainThread train;

QString str2;
static QBrush *tb = 0;
static QPen *tp = 0;

draughtView::draughtView(QCanvas* canvas, draught* parent) : QCanvasView( canvas, parent )
{
  // set statusbar shortcut
  sbar = parent->statusBar();
  draft = parent;
  wins[0]=0;wins[1]=0;wins[2]=0;Ato=0;
}

draughtView::~draughtView()
{
if(playing.locked())mike->dep=-infinitie;
sleep(1);
}

class EdgeItem;
class NodeItem;

class EdgeItem: public QCanvasLine
{
public:
    EdgeItem( NodeItem*, NodeItem*, QCanvas *canvas );
    void setFromPoint( int x, int y ) ;
    void setToPoint( int x, int y );
    static int count() { return c; }
    void moveBy(double dx, double dy);
private:
    static int c;
};

static const int imageRTTI = 984376;


class ImageItem: public QCanvasRectangle
{
public:
    ImageItem( QImage img, QCanvas *canvas );
    ImageItem( QImage img, QCanvas *canvas,bool set );
    int rtti () const { return imageRTTI; }
    bool hit( const QPoint&) const;
    bool isMoveable();
    void setMoveable(bool);
protected:
    void drawShape( QPainter & );
private:
    bool moveable;
    QImage image;
    QPixmap pixmap;
};


ImageItem::ImageItem( QImage img, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(img)
{
    setSize( image.width(), image.height() );
    moveable=true;

#if !defined(Q_WS_QWS)
    pixmap.convertFromImage(image, OrderedAlphaDither);
#endif
}

ImageItem::ImageItem( QImage img, QCanvas *canvas, bool set )
    : QCanvasRectangle( canvas ), image(img)
{
    setSize( image.width(), image.height() );
    moveable=set;

#if !defined(Q_WS_QWS)
    pixmap.convertFromImage(image, OrderedAlphaDither);
#endif
}

bool ImageItem::isMoveable()
{
	return moveable;
}
void ImageItem::setMoveable(bool set)
{
	moveable=set;
}

void ImageItem::drawShape( QPainter &p )
{
#if defined(Q_WS_QWS)
    p.drawImage( int(x()), int(y()), image, 0, 0, -1, -1, OrderedAlphaDither );
#else
    p.drawPixmap( int(x()), int(y()), pixmap );
#endif
}

bool ImageItem::hit( const QPoint &p ) const
{
    int ix = p.x()-int(x());
    int iy = p.y()-int(y());
    if ( !image.valid( ix , iy ) )
        return FALSE;
    QRgb pixel = image.pixel( ix, iy );
    return qAlpha( pixel ) != 0;
}


class NodeItem: public QCanvasEllipse
{
public:
    NodeItem( QCanvas *canvas );
    ~NodeItem() {}

    void addInEdge( EdgeItem *edge ) { inList.append( edge ); }
    void addOutEdge( EdgeItem *edge ) { outList.append( edge ); }

    void moveBy(double dx, double dy);

  QPoint center() { return boundingRect().center(); }

private:
    QPtrList<EdgeItem> inList;
    QPtrList<EdgeItem> outList;
};


int EdgeItem::c = 0;


void EdgeItem::moveBy(double, double)
{
    //nothing table
}

EdgeItem::EdgeItem( NodeItem *from, NodeItem *to, QCanvas *canvas )
    : QCanvasLine( canvas )
{
    c++;
    setPen( *tp );
    setBrush( *tb );
    from->addOutEdge( this );
    to->addInEdge( this );
    setPoints( int(from->x()), int(from->y()), int(to->x()), int(to->y()) );
}

void EdgeItem::setFromPoint( int x, int y )
{
    setPoints( x,y, endPoint().x(), endPoint().y() );
}

void EdgeItem::setToPoint( int x, int y )
{
    setPoints( startPoint().x(), startPoint().y(), x, y );
}

void NodeItem::moveBy(double dx, double dy)
{
    QCanvasEllipse::moveBy( dx, dy );

    QPtrListIterator<EdgeItem> it1( inList );
    EdgeItem *edge;
    while (( edge = it1.current() )) {
        ++it1;
        edge->setToPoint( int(x()), int(y()) );
    }
    QPtrListIterator<EdgeItem> it2( outList );
    while (( edge = it2.current() )) {
        ++it2;
        edge->setFromPoint( int(x()), int(y()) );
    }
}

NodeItem::NodeItem( QCanvas *canvas )
    : QCanvasEllipse( 6, 6, canvas )
{
    setPen( *tp );
    setBrush( *tb );
    setZ(5);
}
//User+100 = 38418992
    class trainEvent : public QCustomEvent
	{
	public:
		trainEvent() : QCustomEvent( 346898){}       ///Auto train  movement
	};

    class playEvent : public QCustomEvent
	{
	public:
		playEvent() : QCustomEvent( 346878 ){}        ///Human movement
	};

void draughtView::customEvent( QCustomEvent * ew )
    {
        if ( ew->type() == 346898) {                         /// It must be a trainEvent
		atomove();
        }
	else if ( ew->type() == 346878 ) {                    /// It must be a playEvent
		makemove();
        }
    }

void playThread::run()  
 	{
	if(playing.locked())return;
	playing.lock();
	pFig->whowin=mike->play_it(pFig->pieces.PlayAmen,pFig->movelist1);
    	playEvent* be = new playEvent();
    	QApplication::postEvent(pFig, be );  // Qt will delete it when done
        playing.unlock();
}

void trainThread::run() 
{
	if(playing.locked())return;
	playing.lock();
	int i;

	for(;;)
	{
		for(i=0;i<130;i++)
		{
		mkmove++;
if(!pFig->speed)usleep(500000);
		if(pFig->nugame){i=0;pFig->nugame=0;}
		pFig->pieces.PlayAmen=!pFig->pieces.PlayAmen;
if(pFig->pieces.PlayAmen)
{mike->emg=pFig->pieces.enemymen;mike->ekg=pFig->pieces.enemykings;mike->cmg=pFig->pieces.compmen;mike->ckg=pFig->pieces.compkings;}
else	{mike->cmg=pFig->pieces.enemymen;mike->ckg=pFig->pieces.enemykings;mike->emg=pFig->pieces.compmen;mike->ekg=pFig->pieces.compkings;}

				pFig->whowin=mike->play_it(pFig->pieces.PlayAmen,pFig->movelist1);
    				trainEvent* ce = new trainEvent();
				if(pFig->killer)break;
    				QApplication::postEvent(pFig, ce ); // Qt will delete it when done

		}
	if(pFig->killer)break;
	}
	playing.unlock();mkmove--;
	pFig->nugame=0;pFig->pieces.cpturn=0;pFig->Ato=0;
	return;			 					// thread completed successfully
}						 

void draughtView::resetHash()
{
	for(int z=0;z<64;z++)
		{
			hash[z].num_repeats=0;
			hash[z].cm=0xFFFFFFFFFFFFFFFFLL;
		}
	num_moves_no_cap_or_man_move=0;mike->pendingDraw=0;
}

int draughtView::check_it(int Sloc,int Dloc,int tipe)//former enforcer
{
int er,who,isM,isK; 
	if(which(Dloc)!=NOMAN)return 11;				///You can't move on top of another
pb=move;*pb=0x88;
	if(phist>pmaxHist)
		{
		phist=plastHist=pieces.Hist;
		QMessageBox::information( this, "Overflow to grass",str );
		}
	write_piece(Sloc,tipe);

	    if(pieces.PlayAmen)
		{ems=pieces.enemymen;eks=pieces.enemykings;cms=pieces.compmen;cks=pieces.compkings;}
	  else	{cms=pieces.enemymen;cks=pieces.enemykings;ems=pieces.compmen;eks=pieces.compkings;}
								//if turn==0 process human  move
    if(!take)
  	{
	isM=isMtakes();
	isK=isKtakes();
	pskip=0xf;
  	}
  	else
  		{
	 	if(pSloc!=Sloc)return 24;			///Please Take your Take
		isK=1;isM=1;
  		}

if(!pieces.cpturn)						  //if turn==0 process human  move
	{									// human animation
		if(!(mask[Dloc]&validsq))return 10;         	///That square is invalid
		if(tipe==MANA||tipe==KINGA)return 9;		///Don't move my Pieces

		if(tipe==KINGB)
			{
			if(isK|isM)
				{
				er=KtakesLgl(pb,pskip,Sloc,Dloc);
				if(er==AMBIG)return AMBIG;	    ///Ambiguous:- Please take single steps
				if(er<1)return 14;                  ///Please take with king
				num_moves_no_cap_or_man_move=0;
				//decideTake(Sloc,Dloc,tipe);
				if(!take){*phist=(Sloc<<3 | tipe)<<23 | 5;cp=phist; phist++;*phist=6;jucks=9;}
				take=er;
				}
			   else
				{
				if(!Kmove(Sloc, Dloc)){return 13;}   /// King can move only diagonally
				updateThem(Sloc,Dloc,tipe);
				return 0;
				}

		}

	if(tipe==MANB)
		{
			if(isM||isK)
				{
				er=MtakesLgl(pb,Sloc,Dloc);
				if(er==AMBIG)return AMBIG;
				if(er<1)return 8;		               ///Please Take with your MAN
				num_moves_no_cap_or_man_move=0;
				if(!take){*phist=(Sloc<<3 | tipe)<<23 | 5;cp=phist; phist++;*phist=6;jucks=9;}
				//decideTake(Sloc,Dloc,tipe);
				take=er;
				}
			   else
				{
				if(Dloc-Sloc!=9 && Dloc-Sloc!=7)return 6;	///Men move one space diagonally
				updateThem(Sloc,Dloc,tipe);num_moves_no_cap_or_man_move=0;
				return 0;
				}

		}
	}
	
	//////////////////////////////////////////////////////////////
	///if pieces.cpturn process comp  move
	//////////////////////////////////////////////////////////////
	
	else 
	{									// comp animation

		if(((tipe==KINGA)||(tipe==KINGB)))
			{
			if(isK)
				{
				er=KtakesLgl(pb,pskip,Sloc,Dloc);
				if(er<1)return 140;				//Please Take with your KING
				num_moves_no_cap_or_man_move=0;
				//decideTake(Sloc,Dloc,tipe);
				if(!take){*phist=(Sloc<<3 | tipe)<<23 | 5;cp=phist; phist++;*phist=6;jucks=9;}
				take=er;
				}
			else
				{
				if(!Kmove(Sloc, Dloc)){return 130;}		//King can move only diagonally
				updateThem(Sloc,Dloc,tipe);
				return 0;
				}

			}

		if(((tipe==MANA)||(tipe==MANB)))
			{

			if(isM)

				{
				er=MtakesLgl(pb,Sloc,Dloc);		//Get the list of the move that matches Sloc,Dloc if any
				if(er<1){return 80;}			//Please Take with your MAN
				num_moves_no_cap_or_man_move=0;		//Draw indicator
									//5 mean Dloc location 6 mean captures takes
				if(!take){*phist=(Sloc<<3 | tipe)<<23 | 5;cp=phist; phist++;*phist=6;jucks=9;}
				take=er;
				}
			else
				{
				updateThem(Sloc,Dloc,tipe);num_moves_no_cap_or_man_move=0;
				return 0;
				}

			}
	}


// Sloc    tipe     Dloc  tipe          unused       pieces.playAmen       pieces.cpturn           terminator #5

// 111111  111      111111  111        111111111             1                    1                     111           ///one 32bit

// captures
// loc     tipe     loc     tipe        loc   tipe      number of captures in int       terminator #6

// 111111  111      111111  111       111111  111                 11                         111


//		Animate the move list cpturn(*pbest)

int tp,prom;
tp=0;
		while(*(pb+1)!=0x88)
		{
			if(*pb==0x88)break;
			if(!tp)tp++;                             //write source and dest

			erase_sq(*(pb));	
								//Erase start position
			erase_item(*(pb));			//Update start Square

			who=which(*(pb+1));
			erase_sq(*(pb+1));			//Erase Captured piece
			erase_item(*(pb+1));			//Update Captured Square

			write_piece(*(pb+2),tipe);		//Write moving piece to board
			if(pieces.cpturn)
			{
				write_item(*(pb+2),tipe);	//Update square moved to

			}
			if(jucks>27){*phist|= ((((jucks/9)-1)<<3));phist++;*phist=6;jucks=9;}
			tp=(*(pb+1)<<3|who);  
			*phist|=tp<<(32-jucks);			//write source and dest of captures
			jucks+=9;			        //(jucks/9)<<9)mean the number of captures in one int
			pb+=2;
		}

			        				//0x3 mean still capturing

		canvas()->update();
		pskip=*(pb+2);
		pSloc=Dloc;

		if(take==2)
			{
			cp=phist;
			while((*cp&7)!=5)cp--;			//search for Dloc's integer
			prom=promotion(!pieces.PlayAmen);	//move done check to crown king
	
								//if(prom!=0x67)*cp|=prom<<14; there was a corination

			if(prom==0x67)prom=tipe;
			*phist|= ((((jucks/9)-1)<<3));  
		if(!movfime)
			*cp|=(Dloc<<3 | prom)<<14 | (pieces.PlayAmen<<1 | pieces.cpturn)<<3;      //insert Dloc+tipe etc
		else	*cp|=(Dloc<<3 | prom)<<14 | ((!pieces.PlayAmen)<<1 | !pieces.cpturn)<<3;

				phist++;plastHist=phist;pskip=0x77;

			}
		return 0;
}

void draughtView::updateThem(int Sloc,int Dloc,int tipe)
{	
int prom=0x67;
QString str3;
			
				take=2;

				erase_sq(Sloc);				//Erase start position
				write_piece(Dloc,tipe);			//Write moving piece to board
				write_item(Dloc,tipe);			//Update square moved to

				prom=promotion(!pieces.PlayAmen);    	//0x88 mean move done	
				if(prom==0x67)prom=tipe;           	//prom=which(prom);
		if(!movfime)
			*phist=(Sloc<<3 | tipe)<<23 | (Dloc<<3 | prom)<<14 | (pieces.PlayAmen<<1 | pieces.cpturn)<<3 |  0x5;
		else	*phist=(Sloc<<3 | tipe)<<23 | (Dloc<<3 | prom)<<14 | ((!pieces.PlayAmen)<<1 | !pieces.cpturn)<<3 |  0x5;

phist++;plastHist=phist;
}
///////////////////////////////////////////////////////////////rassssss

int draughtView::Kmove(int Sm,int Dm)
{	
	uint64_t to_map,ck,ek,cm,em,Kmask,star,starK,allpiece;
	int sq,sqbak;

	em=ems;cm=cms;ek=eks;ck=cks;

			sq=sqbak=Sm;			   
			starK=star=mask[Sm];  	           // roll out a king
			to_map=starK;			   // and erase it.. one les king to do
			allpiece=(ems|cms|(eks^starK)|cks);
						   
						           /////////NE//////////
			Kmask=kingNE[sq];    
			Kmask^=allpiece&Kmask;
		while(Kmask&(starK<<=7))               
				{
					eks|=starK;eks^=starK>>7;sq+=7;

					if(Sm==sqbak && Dm==sq)
					{
						ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
						return 1; // One move was legal and enemy completed the turn
					}
				}
	ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
							 /////////NW//////////      
			Kmask=kingNW[sq];    
			Kmask^=allpiece&Kmask;
	while(Kmask&(starK<<=9))               
				{
					  eks|=starK;eks^=starK>>9;sq+=9;
					  if(Sm==sqbak && Dm==sq)
					  {
						ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
						return 1;// One move was legal and enemyleted the turn
					  }
				}
	ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
							/////////SW//////////

			Kmask=kingSW[sq];    
			Kmask^=allpiece&Kmask;
	while(Kmask&(starK>>=7))
				{
		   			  eks|=starK;eks^=starK<<7;sq-=7;
					  if(Sm==sqbak && Dm==sq)
					  {
						ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
						return 1;		// One move was legal and enemyleted the turn
					  }
				}
		ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
								/////////SE//////////
			Kmask=kingSE[sq];    
			Kmask^=allpiece&Kmask;
	while(Kmask&(starK>>=9))
				{	
		   		  eks|=starK;eks^=starK<<9;sq-=9;
				  if(Sm==sqbak && Dm==sq)
					  {
						ems=em;cms=cm;eks=ek;cks=ck;starK=star;sq=sqbak;
						return 1;		// One move was legal and enemyleted the turn
					  }
				}
			
	return 0;
}


int draughtView::isMtakes()
{
	uint64_t allenemy,manland;

	allenemy=ems|eks;
	manland=~(cms|cks|allenemy)&validsq;

	if(manland&((cms<<7)&allenemy)<<7)return 1;
		
	if(manland&((cms<<9)&allenemy)<<9)return 1;

	if(manland&((cms>>9)&allenemy)>>9)return 1;
	
	if(manland&((cms>>7)&allenemy)>>7)return 1;
	

	return 0;
}
int draughtView::MtakesLgl(unsigned int *pbest,int man,int dest)
{
	int e=-1,a=-1;
	uint64_t to_map,capture,allenemy,cm,em,ek, ck,manland;
	int to_sq;

		fst=1;

		capture=mask[man];
		cm=cms;em=ems;ck=cks;ek=eks;
		allenemy=em|ek;
		manland=~(cms|cks|allenemy)&validsq;
		to_map=manland&((capture<<7)&allenemy)<<7;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq-14];
			cms|=mask[to_sq];
			ems&=notmask[to_sq-7];
			eks&=notmask[to_sq-7];
			a=ppMtakesLgl(pbest+2,to_sq,dest,1,e);
			cms=cm;ems=em;cks=ck;eks=ek;
			if(to_sq==dest)// && a==-1
			{
				*(pbest+3)=0x88;
				*pbest=to_sq-14;	//start
				*(pbest+1)=to_sq-7;	//capture
				*(pbest+2)=to_sq;	//end
				if(a==1)return FINAL;
				return PARTIAL;
			}

			if(e<a)
			{
				e=a;
				*pbest=to_sq-14;	//start
				*(pbest+1)=to_sq-7;	//capture
				*(pbest+2)=to_sq;	//end
			}
	   }
	
		to_map=manland&((capture<<9)&allenemy)<<9;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq-18];
			cms|=mask[to_sq];
			ems&=notmask[to_sq-9];
			eks&=notmask[to_sq-9];
			a=ppMtakesLgl(pbest+2,to_sq,dest,1,e);
			cms=cm;ems=em;cks=ck;eks=ek;
			if(to_sq==dest)
			{
				*(pbest+3)=0x88;
				*pbest=to_sq-18;	//start
				*(pbest+1)=to_sq-9;	//capture
				*(pbest+2)=to_sq;	//end
				if(a==1)return FINAL;
				return PARTIAL;
			}

			if(e<a)
			{
				e=a;
				*pbest=to_sq-18;	//start
				*(pbest+1)=to_sq-9;	//capture
				*(pbest+2)=to_sq;	//end
			}
	   }

		to_map=manland&((capture>>9)&allenemy)>>9;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq+18];
			cms|=mask[to_sq];
			ems&=notmask[to_sq+9];
			eks&=notmask[to_sq+9];
			a=ppMtakesLgl(pbest+2,to_sq,dest,1,e);
			cms=cm;ems=em;cks=ck;eks=ek;
			if(to_sq==dest)
			{
				*(pbest+3)=0x88;
				*pbest=to_sq+18;	//start
				*(pbest+1)=to_sq+9;	//capture
				*(pbest+2)=to_sq;	//end
				if(a==1)return FINAL;
				return PARTIAL;
			}

			if(e<a)
			{
				e=a;
				*pbest=to_sq+18;	//start
				*(pbest+1)=to_sq+9;	//capture
				*(pbest+2)=to_sq;	//end
			}

	   }

		to_map=manland&((capture>>7)&allenemy)>>7;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq+14];
			cms|=mask[to_sq];
			ems&=notmask[to_sq+7];
			eks&=notmask[to_sq+7];
			a=ppMtakesLgl(pbest+2,to_sq,dest,1,e);
			cms=cm;ems=em;cks=ck;eks=ek;
			if(to_sq==dest)
			{
				*(pbest+3)=0x88;
				*pbest=to_sq+14;	// start
				*(pbest+1)=to_sq+7;	// capture
				*(pbest+2)=to_sq;	// end
				if(a==1)return FINAL;	// final move
				return PARTIAL;		// partial single move
			}

			if(e<a)
			{
				e=a;
				*pbest=to_sq+14;	//start
				*(pbest+1)=to_sq+7;	//capture
				*(pbest+2)=to_sq;	//end
			}
	   }

		if(e==infinitie)	return AMBIG;	// ambiquity
		if(e>=1)		return FINAL;	// final move

		return 0;

}

int draughtView::ppMtakesLgl(unsigned int *pbest,int man,int dest,int numtake,int e)
{
	int a=0;
	uint64_t to_map,capture,allenemy,cm,em,ek, ck,manland;
	int to_sq,tokins=0;
		capture=mask[man];
		cm=cms;em=ems;ck=cks;ek=eks;
		allenemy=em|ek;
		manland=~(cms|cks|allenemy)&validsq;
		to_map=manland&((capture<<7)&allenemy)<<7;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq-14];
			cms|=mask[to_sq];
			ems&=notmask[to_sq-7];
			eks&=notmask[to_sq-7];
			a=ppMtakesLgl(pbest+2,to_sq,dest,numtake+1,e);
			cms=cm;ems=em;cks=ck;eks=ek;tokins++;
			if(e<a)
			{
				e=a;
				*pbest=to_sq-14;	//start
				*(pbest+1)=to_sq-7;	//capture
				*(pbest+2)=to_sq;	//end
			}
	   }
	
		to_map=manland&((capture<<9)&allenemy)<<9;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq-18];
			cms|=mask[to_sq];
			ems&=notmask[to_sq-9];
			eks&=notmask[to_sq-9];
			a=ppMtakesLgl(pbest+2,to_sq,dest,numtake+1,e);
			cms=cm;ems=em;cks=ck;eks=ek;tokins++;
			if(e<a)
			{
				e=a;
				*pbest=to_sq-18;	//start
				*(pbest+1)=to_sq-9;	//capture
				*(pbest+2)=to_sq;	//end
			}
	   }

		to_map=manland&((capture>>9)&allenemy)>>9;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq+18];
			cms|=mask[to_sq];
			ems&=notmask[to_sq+9];
			eks&=notmask[to_sq+9];
			a=ppMtakesLgl(pbest+2,to_sq,dest,numtake+1,e);
			cms=cm;ems=em;cks=ck;eks=ek;tokins++;
			if(e<a)
			{
				e=a;
				*pbest=to_sq+18;	//start
				*(pbest+1)=to_sq+9;	//capture
				*(pbest+2)=to_sq;	//end
			}

	   }

		to_map=manland&((capture>>7)&allenemy)>>7;
		if(to_map) 
		{
			to_sq=LSBL(to_map);
			to_map^=mask[to_sq];
			cms^=mask[to_sq+14];
			cms|=mask[to_sq];
			ems&=notmask[to_sq+7];
			eks&=notmask[to_sq+7];
			a=ppMtakesLgl(pbest+2,to_sq,dest,numtake+1,e);
			cms=cm;ems=em;cks=ck;eks=ek;tokins++;
			if(e<a)
			{
				e=a;
				*pbest=to_sq+14;	//start
				*(pbest+1)=to_sq+7;	//capture
				*(pbest+2)=to_sq;	//end
			}
	   }

		if(!tokins)
		{
			if(man==dest)
			{
				if(fst || (sigeMK==(ems|eks)))
				{
					if(e<numtake)
					{
						*(pbest+1)=0x88;
						fst=0;
						sigeMK=(ems|eks);
						return numtake;		//Was on a maxtake path and move ends turn
					}
				}
				else return infinitie;
			}
		}
		return e;						//Was not on a maxtake path or legal

}

int draughtView::isKtakes()
{	
	uint64_t to_map,allcomp,Kmask,star,starK,allpiece,allenemy;
	int sq;

	to_map=cks;
	allenemy=ems|eks;allcomp=cms|cks;
	while (to_map) 
	{
		sq=LSBL(to_map);
		starK=star=mask[sq];       	   // roll out a king
		to_map^=starK;			   // and erase it.. one les king to do
		allpiece=(cms|allenemy|(cks^starK));
						   
						   /////////NE//////////
		if((kingNE[sq]&(allenemy))!=0)
		{
			Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
			while(Kmask&(starK<<=7))               
			{
				if(starK&allenemy)return 1;							     
			}
			starK=star;
		}
							 /////////NW//////////      
		    
		if((kingNW[sq]&(allenemy))!=0)
		{
			Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
			while(Kmask&(starK<<=9))               
			{
				if(starK&allenemy)return 1;							     
			}
			starK=star;
		}
					/////////SW//////////

		if((kingSW[sq]&(allenemy))!=0)
		{
			Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
			while(Kmask&(starK>>=7))               
			{
				if(starK&allenemy)return 1;							     
			}
			starK=star;
		}
					/////////SE//////////
		if((kingSE[sq]&(allenemy))!=0)
		{
			Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
			while(Kmask&(starK>>=9))               
			{
				if(starK&allenemy)return 1;							     
			}
			starK=star;
		}
  }

	return 0;
}

int draughtView::KtakesLgl(unsigned int *pbest,int skip,int sq,int dest)
{	
	int e = NOTAKE,a=NOTAKE,cap=1,tokins=0;             //      1s3 2s4 3s1 4s2
	uint64_t em,ek,allcomp,cm, ck,Kmask,star,starK,allpiece,allenemy,starland;
	int take,sqbak,land,sqland;
			sqbak=sq;		
			starK=star=mask[sq];
			cm=cms;em=ems;ck=cks;ek=eks;allenemy=em|ek;allcomp=cm|ck;
			allpiece=(cms|allenemy|(cks^starK));
			fst=1;

  if(skip&1 && (kingNE[sq]&(allenemy))!=0)  
	{				   /////////NE//////////
		Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
		take=0;land=1;
		
		while(Kmask&(starK<<7))               
		{
			starK<<=7;
			if(starK&allenemy)							     
			{
				if(take)
				{
								//a=pursueKtakes(pbest+1,1,sq,numtake+take,maxtake);
					a=ppKtakesLgl(pbest+2,1,sq,dest,e);
					if(a!=NOTAKE)
					{
						land=0;
						if(sq==dest)
						{
							*pbest=sqbak;	//start
							*(pbest+1)=cap;	//capture
							*(pbest+2)=sq;	//end
							*(pbest+4)=11;
							*(pbest+3)=0x88;
							return PARTIAL;
						}
					}

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
					break;
				}
				ems&=~starK;eks&=~starK;cks|=(starK<<=7);cks^=starK>>14;
				take++;cap=sq+7;sq+=14;sqland=sq;starland=starK;
			}
			else
			{
				cks|=starK;cks^=starK>>7;sq+=7;
			}
			if(take)              
			{ 
				a=ppKtakesLgl(pbest+2,10,sq,dest,e);
				if(a!=NOTAKE)
				{
					land=0;
					if(sq==dest)
					{
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
						*(pbest+4)=11;
						*(pbest+3)=0x88;
						return PARTIAL;
					}
				}
				if(e<a)
				{
					e=a;
					*pbest=sqbak;	//start
					*(pbest+1)=cap;	//capture
					*(pbest+2)=sq;	//end
				}
			}
			
		}

		if(land && take)     				// only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{

				if(sqland==dest)
				{
							//Was on a maxtake path and move ends turn
							*pbest=sqbak;
							*(pbest+1)=cap;	//capture
							*(pbest+2)=sqland;
							*(pbest+3)=0x88;
							return FINAL;
				}

				cks^=starland;starland<<=7;sqland+=7;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;starK=star;sq=sqbak;tokins+=take; 
	}
 if(skip&2 && (kingNW[sq]&(allenemy))!=0)                                       
	{						 /////////NW//////////
			Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
			take=0;land=1;
		while(Kmask&(starK<<9))               
			{
			starK<<=9;
			if(starK&allenemy)							     
				{
			   if(take){
						a=ppKtakesLgl(pbest+2,2,sq,dest,e);
						if(a!=NOTAKE)
						{
							land=0;
							if(sq==dest)
							{
								*pbest=sqbak;	//start
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sq;	//end
								*(pbest+4)=7;
								*(pbest+3)=0x88;
								return PARTIAL;
							}
						}

						if(e<a)
						{
							e=a;
							*pbest=sqbak;	//start
							*(pbest+1)=cap;	//capture
							*(pbest+2)=sq;	//end
						}
						   break;
						}
			 
				ems&=~starK;eks&=~starK;cks|=(starK<<=9);cks^=starK>>18;
				take++;cap=sq+9;sq+=18;sqland=sq;starland=starK;
				}
		 
		    else{
				  cks|=starK;cks^=starK>>9;sq+=9;
				}

		if(take)              
				{ 
						a=ppKtakesLgl(pbest+2,5,sq,dest,e);
						if(a!=NOTAKE)
						{
							land=0;
							if(sq==dest)
							{
								*pbest=sqbak;	//start
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sq;	//end
								*(pbest+4)=7;
								*(pbest+3)=0x88;
								return PARTIAL;
							}
						}

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
	
				}
			}
	if(land && take)					// only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{
				if(sqland==dest)
				{
							//Was on a maxtake path and move ends turn
							*pbest=sqbak;
							*(pbest+1)=cap;	//capture
							*(pbest+2)=sqland;
							*(pbest+3)=0x88;
							return FINAL;
				}
				cks^=starland;starland<<=9;sqland+=9;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;starK=star;sq=sqbak;tokins+=take; 
	}

if(skip&4 && (kingSW[sq]&(allenemy))!=0)                                       
	{						/////////SW//////////
		Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>7))               
		{
		starK>>=7;
		   if(starK&allenemy)							     
				{
			   if(take){
						a=ppKtakesLgl(pbest+2,4,sq,dest,e);
						if(a!=NOTAKE)
						{
							land=0;
							if(sq==dest)
							{
								*pbest=sqbak;	//start
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sq;	//end
								*(pbest+4)=14;
								*(pbest+3)=0x88;
								return PARTIAL;
							}
						}

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
				   break;
			   }
				ems&=~starK;eks&=~starK;cks|=(starK>>=7);cks^=starK<<14;
				take++;cap=sq-7;sq-=14;sqland=sq;starland=starK;
				}
		  
			else{
				  cks|=starK;cks^=starK<<7;sq-=7;
				}
		if(take)              
				{ 
						a=ppKtakesLgl(pbest+2,10,sq,dest,e);
						if(a!=NOTAKE)
						{
							land=0;
							if(sq==dest)
							{
								*pbest=sqbak;	//start
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sq;	//end
								*(pbest+4)=14;
								*(pbest+3)=0x88;
								return PARTIAL;
							}
						}

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
	
				}
			}
	if(land && take)      // only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{
				if(sqland==dest)
				{
							//Was on a maxtake path and move ends turn
							*pbest=sqbak;
							*(pbest+1)=cap;	//capture
							*(pbest+2)=sqland;
							*(pbest+3)=0x88;
							return FINAL;
				}
				cks^=starland;starland>>=7;sqland-=7;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;starK=star;sq=sqbak;tokins+=take; 
	}
if(skip&8 && (kingSE[sq]&(allenemy))!=0)                                       
	{						/////////SE//////////
	  Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
	  take=0;land=1;
	while(Kmask&(starK>>9))               
		{
		starK>>=9;
		   if(starK&allenemy)							     
				{
			   if(take){
						a=ppKtakesLgl(pbest+2,8,sq,dest,e);
						if(a!=NOTAKE)
						{
							land=0;
							if(sq==dest)
							{
								*pbest=sqbak;	//start
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sq;	//end
								*(pbest+4)=13;
								*(pbest+3)=0x88;
								return PARTIAL;
							}
						}

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
				   break;
			   }
				ems&=~starK;eks&=~starK;cks|=(starK>>=9);cks^=starK<<18;
				take++;cap=sq-9;sq-=18;sqland=sq;starland=starK;
				}
		  
			else{
				  cks|=starK;cks^=starK<<9;sq-=9;
				}
		if(take)              
				{ 
						a=ppKtakesLgl(pbest+2,5,sq,dest,e);
						if(a!=NOTAKE)
						{
							land=0;
							if(sq==dest)
							{
								*pbest=sqbak;	//start
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sq;	//end
								*(pbest+4)=13;
								*(pbest+3)=0x88;
								return PARTIAL;
							}
						}
					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
				}
			}
	if(land && take)// only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{
				if(sqland==dest)
				{
							//Was on a maxtake path and move ends turn
							*pbest=sqbak;
							*(pbest+1)=cap;	//capture
							*(pbest+2)=sqland;
							*(pbest+3)=0x88;
							return FINAL;
				}
				cks^=starland;starland>>=9;sqland-=9;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;tokins+=take;          //starK=star;sq=sqbak;
	}
		if(e<1)return 0;
		return e;
}

///////////////////////////
int draughtView::ppKtakesLgl(unsigned int *pbest,int skip,int sq,int dest,int e)
{	
	int a=NOTAKE,cap=1,tokins=0;             //      1s3 2s4 3s1 4s2
	uint64_t em,ek,allcomp,cm, ck,Kmask,star,starK,allpiece,allenemy,starland;
	int take,sqbak,land,sqland;
			sqbak=sq;		
			starK=star=mask[sq];
			cm=cms;em=ems;ck=cks;ek=eks;allenemy=em|ek;allcomp=cm|ck;
			allpiece=(cms|allenemy|(cks^starK));

  if(skip&1 && (kingNE[sq]&(allenemy))!=0)  
	{				   /////////NE//////////
		Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
		take=0;land=1;
		
		while(Kmask&(starK<<7))               
		{
			starK<<=7;
			if(starK&allenemy)							     
			{
				if(take)
				{
					a=ppKtakesLgl(pbest+2,1,sq,dest,e);
					if(a!=NOTAKE)land=0;
					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}

					break;
				}
				ems&=~starK;eks&=~starK;cks|=(starK<<=7);cks^=starK>>14;
				take++;cap=sq+7;sq+=14;sqland=sq;starland=starK;
			}
			else
			{
				cks|=starK;cks^=starK>>7;sq+=7;
			}
			if(take)              
			{ 
				a=ppKtakesLgl(pbest+2,10,sq,dest,e);
				if(a!=NOTAKE)land=0;


					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
			}
			
		}

		if(land && take)     // only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{
				if(e<ATAKE)e=ATAKE;
				if(sqland==dest)
				{
					if(fst || (sigeMK==(ems|eks)))
					{
							if(e<FINAL)
							{
								//Was on a maxtake path and move ends turn
								e=FINAL;
								*pbest=sqbak;
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sqland;
								*(pbest+3)=0x88;
								fst=0;
								sigeMK=(ems|eks);
							}

					}
					else return AMBIG;
				}

				cks^=starland;starland<<=7;sqland+=7;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;starK=star;sq=sqbak;tokins+=take; 
	}
 if(skip&2 && (kingNW[sq]&(allenemy))!=0)                                       
	{						 /////////NW//////////
			Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
			take=0;land=1;
		while(Kmask&(starK<<9))               
			{
			starK<<=9;
			if(starK&allenemy)							     
				{
			   if(take){
						a=ppKtakesLgl(pbest+2,2,sq,dest,e);
						if(a!=NOTAKE)land=0;

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
						   break;
						}
			 
				ems&=~starK;eks&=~starK;cks|=(starK<<=9);cks^=starK>>18;
				take++;cap=sq+9;sq+=18;sqland=sq;starland=starK;
				}
		 
		    else{
				  cks|=starK;cks^=starK>>9;sq+=9;
				}

		if(take)              
				{ 
						a=ppKtakesLgl(pbest+2,5,sq,dest,e);
						if(a!=NOTAKE)land=0;

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
	
				}
			}
	if(land && take)		// only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{
				if(e<ATAKE)e=ATAKE;
				if(sqland==dest)
				{
					if(fst || (sigeMK==(ems|eks)))
					{
							if(e<FINAL)
							{
								//Was on a maxtake path and move ends turn
								e=FINAL;
								*pbest=sqbak;
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sqland;
								*(pbest+3)=0x88;
								fst=0;
								sigeMK=(ems|eks);
							}
					}
					else return AMBIG;
				}
				cks^=starland;starland<<=9;sqland+=9;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;starK=star;sq=sqbak;tokins+=take; 
	}

if(skip&4 && (kingSW[sq]&(allenemy))!=0)                                       
	{						/////////SW//////////
		Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>7))               
		{
			starK>>=7;
		   if(starK&allenemy)							     
				{
			   if(take){
						a=ppKtakesLgl(pbest+2,4,sq,dest,e);
						if(a!=NOTAKE)land=0;

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
				   break;
			   }
				ems&=~starK;eks&=~starK;cks|=(starK>>=7);cks^=starK<<14;
				take++;cap=sq-7;sq-=14;sqland=sq;starland=starK;
				}
		  
			else{
				  cks|=starK;cks^=starK<<7;sq-=7;
				}
		if(take)              
				{ 
						a=ppKtakesLgl(pbest+2,10,sq,dest,e);
						if(a!=NOTAKE)land=0;

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
	
				}
			}
	if(land && take)      // only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)            
			{
				if(e<ATAKE)e=ATAKE;
				if(sqland==dest)
				{
					if(fst || (sigeMK==(ems|eks)))
					{
							if(e<FINAL)
							{
								//Was on a maxtake path and move ends turn
								e=FINAL;
								*pbest=sqbak;
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sqland;
								*(pbest+3)=0x88;
								fst=0;
								sigeMK=(ems|eks);
							}
					}
					else return AMBIG;
				}
				cks^=starland;starland>>=7;sqland-=7;cks|=starland;
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;starK=star;sq=sqbak;tokins+=take; 
	}
if(skip&8 && (kingSE[sq]&(allenemy))!=0)                                       
	{						/////////SE//////////
	  Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
	  take=0;land=1;
	while(Kmask&(starK>>9))               
		{
			starK>>=9;
		   if(starK&allenemy)							     
				{
			   if(take){
						a=ppKtakesLgl(pbest+2,8,sq,dest,e);
						if(a!=NOTAKE)land=0;

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
				   break;
			   }
				ems&=~starK;eks&=~starK;cks|=(starK>>=9);cks^=starK<<18;
				take++;cap=sq-9;sq-=18;sqland=sq;starland=starK;
				}
		  
			else{
				  cks|=starK;cks^=starK<<9;sq-=9;
				}
		if(take)              
				{ 
						a=ppKtakesLgl(pbest+2,5,sq,dest,e);
						if(a!=NOTAKE)land=0;

					if(e<a)
					{
						e=a;
						*pbest=sqbak;	//start
						*(pbest+1)=cap;	//capture
						*(pbest+2)=sq;	//end
					}
				}
			}
	if(land && take)                     // only one take so lets send all the landings to negamax.
		{
			cks^=starK;cks|=starland;
			while(Kmask&starland)
			{
				if(e<ATAKE)e=ATAKE;
				if(sqland==dest)
				{
					if(fst || (sigeMK==(ems|eks)))
					{
							if(e<FINAL)
							{
								//Was on a maxtake path and move ends turn
								e=FINAL;
								*pbest=sqbak;
								*(pbest+1)=cap;	//capture
								*(pbest+2)=sqland;
								*(pbest+3)=0x88;
								fst=0;
								sigeMK=(ems|eks);
							}

					}
					else return AMBIG;
				}
				cks^=starland;starland>>=9;sqland-=9;cks|=starland; 
			}
			
		}
		cms=cm;ems=em;cks=ck;eks=ek;tokins+=take;          //starK=star;sq=sqbak;
	}
if(!tokins)return NOTAKE;                                          //return numtake;
	return e;
}

void draughtView::OnBack() 
{
int dest,count,src_n_type;
if(movfime)return;
if(playing.locked())return;
phist--;
if(phist<pieces.Hist){phist=pieces.Hist;return;}  //2 mike->dep=mike->hard;

while((*(phist)&7)==6)
	      ///erase dest copy dest to src update bitboard
	{

				count=(*phist>>3)&3;

				if(count==3){
						erase_sq(((*phist)>>8)&63);
						write_piece((*phist>>8)&63,(*phist>>5)&7);
					     	write_item((*phist>>8)&63,(*phist>>5)&7);
						count--;
					     }
				if(count==2)
					     {
						erase_sq(((*phist)>>17)&63);
						write_piece((*phist>>17)&63,(*phist>>14)&7);
					     	write_item((*phist>>17)&63,(*phist>>14)&7);
						count--;
					     }
				if(count==1)
					     {
						erase_sq(((*phist)>>26)&63);
						write_piece((*phist>>26)&63,(*phist>>23)&7);
					     	write_item((*phist>>26)&63,(*phist>>23)&7);
						count--;
					     }
			phist--;
			if(phist<pieces.Hist){phist=pieces.Hist;return;}  //2 mike->dep=mike->hard;
	}

	if(((*phist)&7)==5)
		{       ///erase dest copy dest to src update bitboard
		
		dest=(*phist>>17)&63;
		src_n_type=(*phist>>23)&0x1ff;
		erase_sq(dest);
		write_piece(src_n_type>>3,src_n_type&7);
		erase_item(dest);
		write_item(src_n_type>>3,src_n_type&7);//phist--;

		pieces.PlayAmen=((*phist>>4)&1); pieces.cpturn=((*phist>>3)&1);
		take=0;hover=0;                              //2 mike->dep=mike->hard;

                if(pieces.cpturn)statuss->setText("My Turn");
		else  statuss->setText("Your Turn");
		canvas()->update();
		return;
		}
	canvas()->update();
	return;
}

void draughtView::OnForward() 
{
int dest_n_type,count,src;
if(movfime)return;
if(playing.locked())return;

if(phist>=plastHist)return;      //2 {mike->dep=mike->hard;return;}

	if(((*phist)&7)==5)
		{      					 //erase dest copy dest to src update bitboard
		
		dest_n_type=(*phist>>14)&0x1ff;
		src=(*phist>>26)&63;
		erase_sq(src);
		write_piece(dest_n_type>>3,dest_n_type&7);
		erase_item(src);
		write_item(dest_n_type>>3,dest_n_type&7);

		pieces.PlayAmen=!(((*phist)>>4)&1); pieces.cpturn=!(((*phist)>>3)&1);
                if(pieces.cpturn)statuss->setText("My Turn");
		else statuss->setText("Your Turn");
		take=0;hover=0;                                  //2 mike->dep=mike->hard;
		canvas()->update();
		resetHash();
		}
	else return;
	      					//erase dest copy dest to src update bitboard	phist++;
phist++;
while((*(phist)&7)==6)
	{
				count=(*phist>>3)&3;

				if(count==3){
						erase_sq(((*phist)>>8)&63);
						erase_item((*phist>>8)&63);   
						count--;
					     }
				if(count==2)
					     {
						erase_sq(((*phist)>>17)&63);
						erase_item((*phist>>17)&63);    
						count--;
					     }
				if(count==1)
					     {
						erase_sq(((*phist)>>26)&63);
						erase_item((*phist>>26)&63);
						count--;
					     }
			phist++;
			if(phist>=plastHist)break;//{mike->dep=mike->hard;break;}
	}
canvas()->update();
return;
}

void draughtView::OnPlay()       ///toggle sides and play assist human play
{
int hardBak;
	if(playing.locked())return;
	if(Ato)return;
	pieces.cpturn=1;
	movfime=!pieces.PlayAmen;
	hardBak=mike->hard;
	mike->hard = 10;            //level[pieces.PlayAmen];      //unused
	turnchange(pieces.PlayAmen);
	mike->hard=hardBak;
}

void draughtView::OnScramble()
{
	if(playing.locked())return;
	if(Ato)return;
	if(!QMessageBox::question(this, "Warning!!","My brain will be randomized\n Are you Really! sure??\n You can always bring back the installed brain by,\n Selecting default_brain \n Or I will learn by playing with you\n Or set me to train myself\n Whatever additional training above the default will be lost\n" ,"&Yes","&No"))
	mike->scramble();
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();canvas()->update();//update();
}

void draughtView::On_def_Brain()
{
	if(playing.locked())return;
	if(Ato)return;
	if(!mike->def_Brain())KMessageBox::information( this,"Sorry" ,"I could not find the default brain" );
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();canvas()->update();               ///gamesPlayed->update();
}

void draughtView::show_current_Brain()
{
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();canvas()->update(); 

}

bool draughtView::OnTrain() 
{
if(playing.locked())return 0;
/*
if(mike->hard<4){
QMessageBox::information(0,"Sorry","I cannot train at novice level\n Please select another level to train\n");
return 0;
}
*/
	pieces.PlayAmen=!pieces.PlayAmen;
	take=0;hover=0;endLoc=0;killer=0;
	score[0]=0;score[1]=0;pieces.cpturn=1;
	movfime=0;nugame=0;Ato=1;
	statuss->setText("Training");
	errors->setText("");
	canvas()->update();
	
	train.start();
return 1;
}

void draughtView::turnchange(int t)
{
	if(playing.locked())return;
  if(t)
	{mike->emg=pieces.enemymen;mike->ekg=pieces.enemykings;mike->cmg=pieces.compmen;mike->ckg=pieces.compkings;pieces.PlayAmen=t;}
         else{mike->cmg=pieces.enemymen;mike->ckg=pieces.enemykings;mike->emg=pieces.compmen;mike->ekg=pieces.compkings;}

	errors->setText("");canvas()->update();
	statuss->setText("My Turn");canvas()->update();
	claat.start();
    return;
}

void draughtView::makemove()
{
   unsigned int *tokn;
   int i,back;
  	tokn=movelist1;

						// No winner yet	

	top="top       ";top+=QString::number( wins[1], 10 );top+=space;top+=QString::number((double) score[1],'g',4);
	bot="bot       ";bot+=QString::number( wins[0], 10 );bot+=space;bot+=QString::number((double) score[0],'g',4);

	scoreTop->setText(top);scoreTop->show();
	scoreBot->setText(bot);scoreBot->show();

if(whowin==0)
	{
	
	wins[1-pieces.PlayAmen]++; numGames++;
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();
	if(!QMessageBox::question(this, "You Won..","Do you wish to playing another" ,"&Yes","&No"))
	{pieces.black_on_top=!pieces.black_on_top;initialiser(1);}
	else resetHash();
	return;
	}



if(whowin==3)
	{

	wins[2]++; numGames++;
	dra="draws   ";dra+=QString::number( wins[2], 10 );
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
	draws->setText(dra);draws->show();
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();
	if(!QMessageBox::question(this, "Game Drawn..","Do you wish to playing another" ,"&Yes","&No"))
	{pieces.black_on_top=!pieces.black_on_top;initialiser(1);return;}
	else {resetHash();alreadyDrawn=1;}
		
	}

if(!muted)KAudioPlayer::play(ssnd);

for(i=0;i<10;i++) 
		{
		back=which(*(tokn+i));				//Get the tipe of piece being moved
		erase_sq  (*(tokn+i));				//Erase it from the array
		erase_item(*(tokn+i));
		  if(check_it(*(tokn+i),*(tokn+i+1),back))      // if enforcer return 1 move is illegal
			{                                       //  so undo move
			write_piece(*(tokn+i),back);
			write_item(*(tokn+i),back);
			QMessageBox::information(0,"sorry","I screwed up makekmove");
			}
		if(take==2)break;
		}
//		take=0;	
if(whowin==1)
	{

	wins[pieces.PlayAmen]++; numGames++;
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();		
	if(!QMessageBox::question(this, "I Won..","Do you wish to playing another" ,"&Yes","&No"))

	{pieces.black_on_top=!pieces.black_on_top;initialiser(1);}
	else resetHash();
	return;
	}

	take=0;hover=0;

	if(movfime){
	pieces.PlayAmen=1;pieces.cpturn=1;//movfime=0;
	statuss->setText("My Turn Force me");canvas()->update(); 
	}
	else {
	pieces.PlayAmen=0;pieces.cpturn=0;
	statuss->setText("Your Turn");canvas()->update(); 
	}
	return;
		
}

void draughtView::atomove()
{
   unsigned int *tokn;
   int i,back;
  	tokn=movelist1;
						// No winner yet	
	top="top       ";top+=QString::number( wins[1], 10 );top+=space;top+=QString::number((double) score[1],'g',4);
	bot="bot       ";bot+=QString::number( wins[0], 10 );bot+=space;bot+=QString::number((double) score[0],'g',4);
	scoreTop->setText(top);scoreTop->show();
	scoreBot->setText(bot);scoreBot->show();

if(whowin==0)
	{
	wins[1-pieces.PlayAmen]++; numGames+=2;
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );          //you win
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();
	atoInitialiser();
	return;
	}

if(whowin==3)
	{
	wins[2]++; numGames+=2;
	dra="draws   ";dra+=QString::number( wins[2], 10 );
	gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );        //draw
	draws->setText(dra);draws->show();
	gamesPlayed->setText(gmsplayd);gamesPlayed->show();
	atoInitialiser();
	return;
	}

		for(i=0;i<10;i++) 
		{
		back=which(*(tokn+i));				//Get the tipe of piece being moved
		erase_sq  (*(tokn+i));				//Erase it from the array
		erase_item(*(tokn+i));

		if(check_it(*(tokn+i),*(tokn+i+1),back))    // if enforcer return 1 move is illegal
			{                                       //  so undo move
			write_piece(*(tokn+i),back);
			write_item(*(tokn+i),back);
			QMessageBox::information(0,"sorry","I screwed up in atomove");
			mkmove--;mike->dep=-infinitie;killer=1;	
			return;
			}
		if(take==2)break;
		}
		take=0;	
if(whowin==1)
		{
		wins[pieces.PlayAmen]++; numGames+=2;
		gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );          //I win
		gamesPlayed->setText(gmsplayd);gamesPlayed->show();
		atoInitialiser();
		return;
		}
	
		mkmove--;
		return;
}

int draughtView::which( int loc)
{
	uint64_t piece;
			piece=mask[loc];
			if(piece&(pieces.compmen))return MANA;
			if(piece&(pieces.enemymen))return MANB;
			if(piece&(pieces.compkings))return KINGA;
			if(piece&(pieces.enemykings))return KINGB;
			return NOMAN;
}

void draughtView::write_piece(int loc,int who)
{
	if(who==MANA){pieces.compmen|=mask[loc];return;}
	if(who==MANB){pieces.enemymen|=mask[loc];return;}
	if(who==KINGA){pieces.compkings|=mask[loc];return;}
	if(who==KINGB){pieces.enemykings|=mask[loc];return;}
}

void draughtView::erase_sq(int loc)
{
	pieces.compmen&=notmask[loc];
	pieces.enemymen&=notmask[loc];
	pieces.compkings&=notmask[loc];
	pieces.enemykings&=notmask[loc];
}

void draughtView::erase_piece(int loc,int tipe)
{
	if(tipe==MANA || tipe==KINGA){pieces.compmen&=notmask[loc];pieces.compkings&=notmask[loc];}
	else if(tipe==MANB || tipe==KINGB){pieces.enemymen&=notmask[loc];pieces.enemykings&=notmask[loc];}
}

int draughtView::position(int the_x,int the_y)
{
	int err= 0x67;

	the_x=(int)(the_x/inc);
	the_y=(int)(the_y/inc);

	if(the_x>7 || the_x<0 || the_y>7 || the_y<0)return err;
	return 63-(8*the_y+the_x);
}

void draughtView::get_xy(int *xie,int *yie,int loc)
{
	*yie=7-loc/8;
	*xie=7-loc%8;
						 ///     if(mirror){x=7-x;}
	*xie=ofsetxy+(*xie)*inc; 
 	*yie=2+ofsetxy+(*yie)*inc;
}

int draughtView::LSBL(uint64_t  value)
{
int i;
uint64_t skim=0x1LL;
	for(i=0;i<=63;i++)
		{
		if(value&skim)break;
		skim<<=1;
		}
		return i;
}

int draughtView::MSBL(uint64_t  value)
{
int i;
uint64_t skim=0x8000000000000000LL;
	for(i=63;i>=0;i--)
		{
		if(value&skim)break;
		skim>>=1;
		}
	return i;
}

int draughtView::promotion(int side)
{
uint64_t tmp;
unsigned int him;

  	if(side==0)
	{
	        tmp=pieces.compmen&0x55LL; 
		if(tmp){ 
		pieces.compkings=pieces.compkings|tmp;
		pieces.compmen^=tmp;
		him=LSBL(tmp);
		erase_item(him);
		write_item(him,KINGA);
		canvas()->update();
		return KINGA;
		}
	return 0x67;
	}
	else
	{
	        tmp=pieces.enemymen&0xaa00000000000000LL;
		if(tmp){
		pieces.enemykings=pieces.enemykings|tmp;
		pieces.enemymen^=tmp;
		him=MSBL(tmp);
		erase_item(him);
		write_item(him,KINGB);
		canvas()->update();
		return KINGB;
		}
	return 0x67;
	}
	
}

void draughtView::stall(){               //waste time
	moving=0;
	moving_start.setX(0);
	moving_start.setY(0);
}
void draughtView::contentsMousePressEvent(QMouseEvent* em)
{
if ((em->button()!=LeftButton))return;
if(pieces.cpturn){moving=0;return;}
    QPoint p = inverseWorldMatrix().map(em->pos());
    QCanvasItemList l=canvas()->collisions(p);
    for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
        if ( (*it)->rtti() == imageRTTI ) {
            ImageItem *item= (ImageItem*)(*it);
            if ( !item->hit( p ) || !item->isMoveable())
                continue;
		}
	
	moving = *it;
						//Initialise the start_x/y to the piece the mouse is over
		Sloc=position(p.x(),p.y());
		if(Sloc==0x67){moving=0;return;}
		old=which(Sloc);
		if(old==NOMAN){moving=0;return;}
		moving->setZ(8); 
		moving_start = p;
		return;
		}
		moving=0;

}
							//void doHuman();
void draughtView::contentsMouseReleaseEvent(QMouseEvent* em)
{
int xt,yt,err;
QString str3;

	if ((em->button()!=LeftButton))return;
	QPoint p = inverseWorldMatrix().map(em->pos());
	Dloc=position(p.x(),p.y()); 			//Where mouse release
	get_xy(&xt,&yt,Dloc);
	
if( moving )
	{
	
	if(which(Dloc)!=NOMAN)        			//can't move on top of another
		{
		get_xy(&xt,&yt,Sloc);moving->setX(xt);moving->setY(yt);moving->setZ(5);canvas()->update();moving=0;
		if(Dloc!=Sloc){errors->setText("Don't move on top of another.");canvas()->update();}
		return;
		}

			moving->setX(xt);moving->setY(yt);moving->setZ(5);canvas()->update();

			if(hover==1 && (Dloc!=endLoc) && take==1)
			{
			take=0;	hover=0;pieces.cpturn=1;
			turnchange(!pieces.PlayAmen);  		//turn=!turn;
			return;
			}
			endLoc=Dloc;

			if(!(err=check_it(Sloc,Dloc,old)))     //who
				{
								
				if(take==2)
					{		
					take=0;	hover=0;pieces.cpturn=1;
					turnchange(!pieces.PlayAmen);
					}
				else hover=0;  			//hover=0 cursor lock on piece
				
					//A piece was moved so set the document as changed to prompt for save on exit. 
					//SetModifiedFlag();

				}
				else            	// ERRORS
				{
				write_piece(Sloc,old);
				get_xy(&xt,&yt,Sloc);
			moving->setX(xt);moving->setY(yt);moving->setZ(5);moving=0;


		     if(err==6) errors->setText("Men move one space diagonally.");//canvas()->update();}
		else if(err==8) errors->setText("Please Take with your MAN.");
		else if(err==9) errors->setText("Don't move my Pieces.");
		else if(err==10)errors->setText("That square is invalid.");
		else if(err==13)errors->setText("King can move only diagonally.");
		else if(err==14)errors->setText("Please Take with your KING.");
		else if(err==24)errors->setText("Please Take your Take.");
		else if(err==32)errors->setText("Ambiguous:- Please take single steps.");
				canvas()->update();
				if(take)hover=0;
				else hover=1;return;
				}
	}

}

void draughtView::contentsMouseMoveEvent(QMouseEvent* em)
{
	if ((em->state()!=LeftButton))return;
	if ( moving ) {
		QPoint p = inverseWorldMatrix().map(em->pos());
		moving->moveBy(p.x() - moving_start.x(), p.y() - moving_start.y());
		moving_start = p;
		canvas()->update();
	}

}

void draughtView::clear()
{
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }
}

void draughtView::myBoard()
{
		QCanvasPolygonalItem* i = new ImageItem(boardd_fn,canvas(),false);//boardd_fn
				i->move(border,border);
				i->setZ(0);
				i->show();

		statuss  = new QCanvasText(canvas());
			statuss->setText("status");
			statuss->move(wth*1.15,20);  //not in canvas
			statuss->setZ(5); 
			statuss->show();
		
		scoreTop   = new QCanvasText(canvas());
			scoreTop->setText("score");
			scoreTop->move(wth+33,100);  //not in canvas
			scoreTop->setZ(5); 
			scoreTop->show();
			
		scoreBot   = new QCanvasText(canvas());
			scoreBot->setText("score");
			scoreBot->move(wth+33,130);  //not in canvas
			scoreBot->setZ(5); 
			scoreBot->show();
			
		draws   = new QCanvasText(canvas());
			dra="draws   ";			//dra+=QString::number( wins[2], 10 );
			draws->setText(dra);draws->show();
			draws->move(wth+33,160);  	//not in canvas
			draws->setZ(5); 
			draws->show();
			
		gamesPlayed  = new QCanvasText(canvas());
			gmsplayd="Total AI. Played  ";gmsplayd+=QString::number( numGames, 10 );
			gamesPlayed->setText(gmsplayd);gamesPlayed->show();
									//gamesPlayed->setText("gamesPlayed");
			gamesPlayed->move(wth+33,190);  		//not in canvas
			gamesPlayed->setZ(5); 
			gamesPlayed->show();

		errors   = new QCanvasText(canvas());
			errors->setText("Happy goes the lucky");
			errors->move(wth+33,250); 			 //not in canvas
			errors->setZ(5); 
			errors->show();
}

void draughtView::myPieces()
{
int x,y,loc,s,who;
for(s=0;s<32;s++)
{
	loc=(a[s]);
	who=which(loc);
	get_xy(&x,&y,loc);
	erase_item(x,y);
	QCanvasPolygonalItem *i;
	switch(who)
	{
	case MANA: 	
		if(!pieces.black_on_top)
			i = new ImageItem(mana_fn,canvas());
		else	i = new ImageItem(manb_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	
	case MANB: 	
		if(!pieces.black_on_top)
			i = new ImageItem(manb_fn,canvas());
		else	i = new ImageItem(mana_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	case KINGA: 	
		if(!pieces.black_on_top)
			i = new ImageItem(kinga_fn,canvas());
		else	i = new ImageItem(kingb_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	case KINGB: 	
		if(!pieces.black_on_top)
			i = new ImageItem(kingb_fn,canvas());
		else	i = new ImageItem(kinga_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	
	case NOMAN:	break;
	}

    }

	canvas()->update();  
}

void draughtView::initialiser(bool nue)
 {
	take=0;hover=0;endLoc=0;
	score[0]=0;score[1]=0;
	movfime=0;
   	pmaxHist=pieces.Hist+MAXHIST;
  	resetHash();alreadyDrawn=0;
    	nugame=0;Ato=0;
if(nue){                               //brand new game cleanup and reset all 
pieces.compmen=0xaa55aa0000000000LL;	pieces.enemymen=0x55aa55LL;  pieces.compkings=0LL;pieces.enemykings=0LL; //new full board 
	phist=plastHist=pieces.Hist;
   	pieces.lasthist=0;
   	pieces.curhist=0;

        myPieces();
	if(pieces.black_on_top)
			{
			pieces.PlayAmen=1;
			pieces.cpturn=1;
			turnchange(1);                //need to post a message to turnchange dont wait for return
			}
			else    {
				pieces.PlayAmen=0;
				pieces.cpturn=0;
				}
	}
		else                      //old game previously played reloaded
			{
clear();                   //not quite necessary precaution
myBoard();
			myPieces();
			if(pieces.cpturn)statuss->setText("My Turn");
			else             statuss->setText("Your Turn");
			}
  canvas()->update();
 }


 void draughtView::atoInitialiser()
 {
 					// Starting with nothing
	take=0;hover=0;endLoc=0;
	score[0]=0;score[1]=0;
	movfime=0;
   	pmaxHist=pieces.Hist+MAXHIST;
  	resetHash();alreadyDrawn=0;
    	Ato=1;pieces.cpturn=1;nugame=1;          ///66
	pieces.black_on_top=!pieces.black_on_top;
pieces.compmen=0xaa55aa0000000000LL;	pieces.enemymen=0x55aa55LL;  pieces.compkings=0LL;pieces.enemykings=0LL; //new full board 
	phist=plastHist=pieces.Hist;
   	pieces.lasthist=0;
   	pieces.curhist=0;  
	myPieces();

		if(pieces.black_on_top)pieces.PlayAmen=0;             //reversed  //pieces.PlayAmen)
			else pieces.PlayAmen=1;
	mkmove--;
 }


void draughtView::erase_item(int loc)
{
	int x,y;
	get_xy(&x,&y,loc);
	QPoint p(x+half_inc,y+half_inc);
     	QCanvasItemList list = canvas()->allItems();
    	QCanvasItemList::Iterator it = list.begin();
    	for (; it != list.end(); ++it) {
       	if ( (*it)->rtti() == imageRTTI ) {
            ImageItem *item = (ImageItem*)(*it);
            if ( !item->hit( p ) || !item->isMoveable())continue;
	    
	  if ( *it ){item->hide();delete *it;canvas()->update();}
    	}
    } 
}
     
void draughtView::erase_item(int x,int y)
{
    	QPoint p(x+half_inc,y+half_inc);
    	QCanvasItemList list = canvas()->allItems();
    	QCanvasItemList::Iterator it = list.begin();
    	for (; it != list.end(); ++it) {
        if ( (*it)->rtti() == imageRTTI ) {
            ImageItem *item = (ImageItem*)(*it);
            if ( !item->hit( p ) || !item->isMoveable())continue;

	  if ( *it ){item->hide();delete *it;canvas()->update();}
    	}
    }
}

void draughtView::get_star(int loc)
{
	int x,y;
	get_xy(&x,&y,loc);
	QPoint p(x+half_inc,y+half_inc);
     	QCanvasItemList list = canvas()->allItems();
    	QCanvasItemList::Iterator it = list.begin();
    	for (; it != list.end(); ++it) {
       	if ( (*it)->rtti() == imageRTTI ) {
            ImageItem *item = (ImageItem*)(*it);
            if ( !item->hit( p ) || !item->isMoveable())continue;
	    
	  if ( *it ) moving=*it;
    	}
    } 
}

void draughtView::write_item(int loc,int who)
{
	int x,y;
	get_xy(&x,&y,loc);
erase_item(x,y);
	QCanvasPolygonalItem *i;
	switch(who)
	{
	case MANA: 	
		if(!pieces.black_on_top)
			i = new ImageItem(mana_fn,canvas());
		else	i = new ImageItem(manb_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	
	case MANB: 	
		if(!pieces.black_on_top)
			i = new ImageItem(manb_fn,canvas());
		else	i = new ImageItem(mana_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	case KINGA: 	
		if(!pieces.black_on_top)
			i = new ImageItem(kinga_fn,canvas());
		else	i = new ImageItem(kingb_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	case KINGB: 	
		if(!pieces.black_on_top)
			i = new ImageItem(kingb_fn,canvas());
		else	i = new ImageItem(kinga_fn,canvas());
			i->move(x,y);
			i->setZ(5);
			i->show();
			break;
	
	
	case NOMAN:	break;
	}
	canvas()->update();
}

void draughtView::reset_score()
{
	wins[0]=0;
	wins[1]=0;
	wins[2]=0;
	top="top       ";
	bot="bot       ";
	dra="draws   ";

	scoreTop->setText(top);scoreTop->show();
	scoreBot->setText(bot);scoreBot->show();
	draws->setText(dra);draws->show();
}

#include "draughtview.moc"

