/*
 * This file is part of Krita
 *
 * Copyright (c) 2006 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _KIS_REDEYEREMOVAL_TOOL_H_
#define _KIS_REDEYEREMOVAL_TOOL_H_

// TODO: remove that
#define LCMS_HEADER <lcms.h>
// TODO: remove it !

#include "kis_tool_non_paint.h"
#include "kis_tool_factory.h"

class WdgRedEyeRemoval;

class KisRedEyeRemovalTool : public KisToolNonPaint {
    Q_OBJECT
    enum Classification {
        REDPIXEL,
        HIGHLIGHTPIXEL,
        NONSKINPIXEL,
        REGIONMEMBER,
        UNDEFINEDPIXEL
    };
    enum RegionStatus {
        NONMEMBER,
        MEMBER,
        BORDERCONNECTED,
        CANDIDAT
    };
    class RedEyeRegion {
        public:
            RedEyeRegion():avePctR(0.),avePctG(0.),aveR(0.), m_mask(0) {}
            ~RedEyeRegion() {
                if(m_mask != 0)
                {
                    delete[] m_mask;
                }
            }
            QRect area() const;
            inline void addPoint(QPoint p) {
                m_points.push_back( p );
                m_uptodate = false;
            }
            inline uint size() const {
                return m_points.size();
            }
            QValueList< QPoint>::iterator begin() {
                return m_points.begin();
            }
            QValueList< QPoint>::iterator end() {
                return m_points.end();
            }
            QValueList< QPoint>::const_iterator begin() const {
                return m_points.begin();
            }
            QValueList< QPoint>::const_iterator end() const {
                return m_points.end();
            }
            bool contains(QPoint p) const {
                return m_points.contains( p );
            }
            RegionStatus* mask() const;
        public:
            double avePctR;
            double avePctG;
            double aveR;
        private:
            /** Recursive function used by mask to fill the holes
             * @return true if there is a connection to the border
             */
            bool fillRec(uint x, uint y, QRect& r) const;
            QValueList< QPoint > m_points;
            mutable QRect m_area;
            mutable bool m_uptodate;
            mutable RegionStatus* m_mask;
    };
    public:
        KisRedEyeRemovalTool();
        virtual ~KisRedEyeRemovalTool();
    public:
        virtual void update (KisCanvasSubject *subject);
        virtual void setup(KActionCollection *collection);
        virtual void paint();
        virtual void paint(KisCanvasPainter& gc);
        virtual void paint(KisCanvasPainter& gc, const QRect& rc);
        virtual void buttonRelease(KisButtonReleaseEvent *e);
        virtual QWidget* createOptionWidget(QWidget* parent);
        virtual QWidget* optionWidget();
    public slots:
        virtual void activate();
        void fixAllRegions();
        void unmarkAllRegions();
    private:
        void regionGrowing( RedEyeRegion& region, Classification* classifications, int x, int y, Classification classifier, QRect rect );
        void regionGrowingSimilar( RedEyeRegion& region, Classification* classifications, int x, int y, Classification classifier, KisPaintDeviceSP device, QRect rect );
        void correctRegion(RedEyeRegion& region);
    private:
        KisImageSP m_currentImage;
        QValueList< RedEyeRegion > m_regions;
        WdgRedEyeRemoval* m_optionsWidget;
};

class KisRedEyeRemovalToolFactory : public KisToolFactory {
    public:
        KisRedEyeRemovalToolFactory() : KisToolFactory() {};
        virtual ~KisRedEyeRemovalToolFactory(){};

        virtual KisTool * createTool(KActionCollection * ac) {
            KisTool * t =  new KisRedEyeRemovalTool();
            t -> setup(ac);
            Q_CHECK_PTR(t);
            return t;
        }
        virtual KisID id() { return KisID("redeyeremovaltool", i18n("Red-Eye Removal Tool")); }
};


#endif
