// angle.h
// Copyright (C)  2002  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.

#ifndef KIG_OBJECTS_ANGLE_H
#define KIG_OBJECTS_ANGLE_H

#include "object.h"

#include "../misc/rect.h"

#include <qpointarray.h>

/**
 * This class is inspired upon one in KGeo.  Some code comes from
 * there too..  Thanks to Marc Bartsch <marc.bartsch@web.de>.
 */
class Angle
  : public Object
{
  typedef Object Parent;
public:
  Angle( const Objects& os );
  Angle( const Angle& a );
  ~Angle();

  virtual bool isa( int type ) const;

  // some type information
  const QCString vBaseTypeName() const;
  static QCString sBaseTypeName();
  const QCString vFullTypeName() const;
  static QCString sFullTypeName();
  const QString vDescriptiveName() const;
  static const QString sDescriptiveName();
  const QString vDescription() const;
  static const QString sDescription();
  const QCString vIconFileName() const;
  static const QCString sIconFileName();
  const int vShortCut() const;
  static const int sShortCut();
  static const char* sActionName();

  bool contains (const Coordinate& o, const ScreenInfo& si ) const;
  void draw ( KigPainter& p, bool showSelection ) const;

  bool inRect (const Rect&) const;

  // arguments
  static void sDrawPrelim ( KigPainter&, const Objects& o );
  static Object::WantArgsResult sWantArgs ( const Objects& os );
  static QString sUseText( const Objects& os, const Object* o );

  Objects getParents() const;

  void calc();
  void calcForWidget( const KigWidget& w );

  // this returns the size of this angle ( in radians, in the range 0 <
  // x < 2*M_PI... )
  double size() const;

  const uint numberOfProperties() const;
  const Property property( uint which, const KigWidget& ) const;
  const QCStringList properties() const;

protected:
  Point* mpts[3];
  std::vector<Coordinate> marrow;
  Rect mr;
  // both of these angles are kept in radians, and converted when
  // necessary...
  double mstartangle;
  double manglelength;
};

#endif
