/**
 This file is part of Kig, a KDE program for Interactive Geometry...
 Copyright (C) 2002  Dominique Devriese <devriese@kde.org>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 USA
**/


#ifndef KGEO_H
#define KGEO_H

#include "../filter.h"

class KSimpleConfig;

// This is an import filter for files generated by the program KGeo,
// which is/was an interactive geometry program in kdeedu.  Kig is
// supposed to be its successor, and this import filter is part of my
// attempt to achieve that :)

// Status: a significant part of kgeo's format is supported, not all
// yet, though..

class KigFilterKGeo
  : public KigFilter
{
public:
  KigFilterKGeo();
  ~KigFilterKGeo();
  bool supportMime ( const QString& mime );
  Result load ( const QString& from, KigDocument& to );
protected:
  Result loadMetrics (KSimpleConfig* );
  Result loadObjects (KSimpleConfig*, KigDocument& os );

  int xMax;
  int yMax;
};

#endif
