/***************************************************************************
                          kplnamespace.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLNAMESPACE_H
#define KPLNAMESPACE_H

#define KPL_NPMAX 20

#include <qstring.h>

/**
  * Kpl namespace. Declares global names.
  * @author Werner Stille
  */
class Kpl
{
public:
  /** Structure contains data error fit settings for parameter fits. */
  struct DataErrorStruct {
    bool fitErrCol;
    double pErrMod[KPL_NPMAX];
    QString errModName, errModPath;
  };
  /** Structure contains autoplot settings. */
  struct AutoStruct {
    bool autoErr, autoNorm, autohPath, autoFit, fitShowDlg, fitSavePar,
         fitFollow, fitNonLin, showSource, autoLogX, autoLogY, addData;
    bool fitPar[KPL_NPMAX];
    int prec, ixAuto, iyAuto, ieAuto, autoGrid, autoSymb, fitMaxIt, fitSymb,
        nyLeg, iSep;
    unsigned colFrame, colGrid, colData, fitColor;
    double xf, yf, x0Auto, xlAuto, y0Auto, ylAuto, fitTol;
    double pFit[KPL_NPMAX];
    char format;
    QString sxAuto, syAuto, shAuto, fitName, fitPath;
    DataErrorStruct err;
  };
};

#endif
