/***************************************************************************
                          imagedlg.h  -  description
                             -------------------
    begin                : Don Jun 5 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEDLG_H
#define IMAGEDLG_H

#include <qwidget.h>
#include <kdialogbase.h>

class QCheckBox;
class QLineEdit;
class ImageItem;
class KplDoc;
class KplDoubleEdit;

/**
  * Image settings dialog class. Provides a dialog for the settings
  * of an EPS image item.
  * @author Werner Stille
  */
class ImageDlg : public KDialogBase
{
  Q_OBJECT
public: 
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ad pointer to image item.
   */
  ImageDlg(QWidget* parent, KplDoc* model, ImageItem* ad);
  /** Destructor. */
  ~ImageDlg();

protected:
  /**
   * Copies settings to image object.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  ImageItem* ad;
  QLineEdit* fileName;
  KplDoubleEdit *ex0, *ey0, *efx, *efy;
  QCheckBox* isotropic;

protected slots:
  /** Displays the dialog for selection of a file. */
  void slotFile();
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
