/***************************************************************************
                          kplgraph.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Wed Sep 08 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcolor.h>
#include "kplgraph.h"

KplGraph::KplGraph() : logx(false), logy(false), kSymb(0), relSiz(1.0),
 fxn(1.0), fyn(1.0), devType(Screen)
{
}

KplGraph::~KplGraph()
{
}

KplGraph::DevTypes KplGraph::type() const
{
  return devType;
}

double KplGraph::relSize() const
{
  return relSiz;
}

int KplGraph::prenum(double a, int ndig, QString& label)
{
  label.sprintf("%.*f", QMAX(0, ndig), a);
  if (ndig == 0)
    label += ".";
  return label.length();
}

unsigned KplGraph::rgbQt(unsigned u)
{
  QColor col(int(u & 0xffL), int((u & 0xff00L) >> 8),
             int((u & 0xff0000L) >> 16));
  return col.rgb();
}

unsigned KplGraph::rgbQt1(unsigned rgb)
{
  QColor col(rgb);
  return unsigned(col.red()) | (unsigned(col.green()) << 8) |
    (unsigned(col.blue()) << 16);
}
