/***************************************************************************
                          rectitem.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ksimpleconfig.h>
#include <klocale.h>
#include "kplchecklistitem.h"
#include "kgraph.h"
#include "rectdlg.h"
#include "rectitem.h"

RectItem::RectItem() : fillStyle(0), width(3.0), height(2.0), dir(0.0)
{
}

RectItem::RectItem(Kpl::AutoStruct* aut) :
 DecoItem(aut), fillStyle(0), width(3.0), height(2.0), dir(0.0)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto - 1.5;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto - 1.0;
}

RectItem::RectItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) :
 DecoItem(plo, aut)
{
  fillStyle = plo->readNumEntry("fillstyle");
  if (!fillStyle)
    if (plo->readBoolEntry("filled"))
      fillStyle = 1;
  width = plo->readDoubleNumEntry("width", 3.0);
  height = plo->readDoubleNumEntry("height", 2.0);
  dir = plo->readDoubleNumEntry("dir");
}

RectItem::RectItem(bool act, int fill, const QString& col,
                   double x, double y, double w, double h, double relSize,
                   double ang) :
 DecoItem(act, col, x, y, relSize), fillStyle(fill), width(w), height(h),
 dir(ang)
{
}

RectItem::~RectItem()
{
}

KplItem::ItemTypes RectItem::iType() const
{
  return Rectangle;
}

void RectItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColData(color);
    double sav = g->setRelSize(relsiz);
    g->rectangle(x0, y0, width, height, fillStyle, dir, &bRect);
    g->setRelSize(sav);
  }
}

void RectItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const
{
  plo->writeEntry("Type", "RECTITEM");
  DecoItem::writePlo(plo, url, abs, m);
  plo->writeEntry("fillstyle", fillStyle);
  plo->writeEntry("width", width);
  plo->writeEntry("height", height);
  if (dir)
    plo->writeEntry("dir", dir);
}

void RectItem::setText(KplCheckListItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Rectangle"));
  QString s1, s2;
  it->setText(2, s1.sprintf("x = %g cm, y = %g cm, ", x0, y0) + i18n("size")
              + s2.sprintf(" %g cm x %g cm", width, height));
}

int RectItem::editItem(QWidget* parent, KplDoc* m, int)
{
  RectDlg dlg(parent, m, this);
  dlg.setCaption(i18n("Rectangle"));
  return dlg.exec();
}

KplItem* RectItem::copy() const
{
  return new RectItem(*this);
}
