/***************************************************************************
                          residualsdlg.cpp  -  description
                             -------------------
    begin                : Sun Jul 15 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qpaintdevicemetrics.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kglobal.h>
#if KDE_VERSION >= 220
#include <kprinter.h>
#else
#include <qprinter.h>
#endif
#include "residualsdlg.h"
#include "kplwidget.h"
#include "kpldoc.h"

ResidualsDlg::ResidualsDlg(QWidget* _parent, KplDoc* model,
                           QList<KplItem>* _items) :
 KDialogBase(Plain, i18n("Residuals"), Close | User1 | User2, Close, _parent,
             0, true, false, i18n("Print"), i18n("Save")),
 items(_items), m(model)
{
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  KConfig* config = KGlobal::config();
  config->setGroup(kapp->instanceName());
  double zoom = config->readDoubleNumEntry("Zoom", 1.0);
  QPaintDeviceMetrics pdm(this);
  int w = qRound(8.27 * zoom * pdm.logicalDpiX());
  int h = qRound(5.85 * zoom * pdm.logicalDpiY());
  vbox->addWidget(new KplWidget(frame, items, w, h, zoom));
  QWidget* d = QApplication::desktop();
  setMaximumSize(QMIN(w + 50, d->width() - 20),
                 QMIN(h + 63, d->height() - 40));
}

ResidualsDlg::~ResidualsDlg()
{
}

void ResidualsDlg::slotUser1()
{
#if KDE_VERSION >= 220
  KPrinter printer;
#else
  QPrinter printer;
#endif
  if (printer.setup(this))
    KplWidget::print(&printer, items);
}

void ResidualsDlg::slotUser2()
{
  KURL url;
  if (m->getWriteURL(this, url, "*.plo\n*"))
    m->saveDocument(url, items);
}
