/***************************************************************************
                          scalebardlg.h  -  description
                             -------------------
    begin                : Sam Jun 14 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCALEBARDLG_H
#define SCALEBARDLG_H

#include <qwidget.h>
#include <decodlg.h>

class QButtonGroup;
class QLineEdit;
class ScaleBarItem;

/**
  * Scale bar settings dialog class. Provides a dialog for the settings
  * of a scale bar decoration item.
  * @author Werner Stille
  */
class ScaleBarDlg : public DecoDlg
{
  Q_OBJECT
public: 
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param sd pointer to scale bar item.
   */
  ScaleBarDlg(QWidget* parent, KplDoc* model, ScaleBarItem* sd);
  /** Destructor. */
  ~ScaleBarDlg();
  
protected:
  /**
   * Copies settings to scale bar item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  ScaleBarItem* sd;
  QLineEdit* eText;
  QButtonGroup* bg;
  KplDoubleEdit* eLen;

protected slots:
  /** Displays dialog to edit text. */
  void slotEditText();
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
