/* -*- c++ -*-
 *
 * systemtray.h
 *
 * Copyright (C) 2004 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

//#include <qtooltip.h>
//#include <klocale.h>
#include <kpopupmenu.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <kicontheme.h>
#include <kdeversion.h>

#include "systemtray.h"

#include <donkeyprotocol.h>

SystemTrayTip::SystemTrayTip(QWidget* parent)
    : QToolTip(parent)
{
}

void SystemTrayTip::maybeTip(const QPoint& /*pos*/)
{
    QRect r( parentWidget()->geometry() );
    QString s = ((SystemTray*)parentWidget())->tooltip;
    if (! r.isValid() || s.isEmpty()) return;
    tip(r, "<b>KMLDonkey</b><br>" + s);
}

SystemTray::SystemTray(QWidget* parent, const char* name)
    : KSystemTray(parent, name)
{
    setPixmap( loadIcon("kmldonkey") );

    setAcceptDrops(true);

    QPopupMenu *popup = (QPopupMenu*)(KMLDonkey::App->factory())->container("systemtray_actions", KMLDonkey::App);
    if (popup) contextMenu()->insertItem(popup); //contextMenu()->insertItem("...", popup);

    tip = new SystemTrayTip(this);

#if KDE_IS_VERSION(3, 4, 0)
    connect( this, SIGNAL( quitSelected() ), kapp, SLOT( quit() ) );
#endif
}

SystemTray::~SystemTray()
{
}

void SystemTray::dragEnterEvent(QDragEnterEvent* event)
{
    event->accept(QUriDrag::canDecode(event));
}

void SystemTray::dropEvent(QDropEvent* event)
{
    KURL::List uri;
    if (KURLDrag::decode(event, uri)) {
        QValueListConstIterator<KURL> it;
        for (it = uri.begin(); it != uri.end(); ++it)
            KMLDonkey::App->donkey->submitURL((*it).url());
    }
}


#include "systemtray.moc"
