/* -*- c++ -*-
 *
 * submit.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __submit_h__
#define __submit_h__

#include <qobject.h>
#include <qintdict.h>
#include <qvaluelist.h>
#include <qstring.h>
#include <kio/job.h>
#include "donkeyprotocol.h"
#include "hostmanager.h"

class Submitter;

class SubmitCallback : public ConsoleCallbackInterface
{
public:
    SubmitCallback(const QString& url, Submitter* submitter);
    void callback(const QString& cmd, const QString& res);
private:
    QString m_url;
    Submitter* m_submitter;
};

class Submitter : public QObject
{

Q_OBJECT

public:

    Submitter(QCString host, bool recursive, QObject* parent = NULL, char* name = NULL);

public slots:

    void submitURL(const QString& url, bool force = false);
    void allDone();
    void callbackDone();

protected slots:

    void donkeyDisconnected(int err);
    void donkeyConnected();
    void donkeyAuthenticating();
    void jobData(KIO::Job* job, const QByteArray& data);
    void jobResult(KIO::Job* job);

private:

    void sendURLs();

    DonkeyProtocol* donkey;
    HostManager* hostManager;
    QString host, uname, pwd;
    int port, done, auth, callbackCount;
    QValueList<QString> list;
    QIntDict<QString> dict;
    bool isRecursive;
    
    QPtrList<SubmitCallback> callbacks;

signals:

    void quit();

};

#endif
