/***************************************************************************
                          arrowitem.cpp  -  description
                             -------------------
    begin                : Sat Apr 14 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <ksimpleconfig.h>
#include "arrowitem.h"
#include "kgraph.h"
#include "utils.h"
#ifndef KPL_CLASSES_ONLY
#include <qlistview.h>
#include "arrowdlg.h"
#endif

ArrowItem::ArrowItem() : dir(0.0), len(1.0)
{
}

ArrowItem::ArrowItem(KplNamespace::AutoStruct* aut) :
 DecoItem(aut), dir(0.0), len(1.0)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto;
}

ArrowItem::ArrowItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut) :
 DecoItem(plo, aut)
{
  dir = plo->readDoubleNumEntry("dir");
  len = plo->readDoubleNumEntry("len", 1.0);
}

ArrowItem::ArrowItem(bool act, const QString& col, double x, double y,
                     double d, double l, double relSize) :
 DecoItem(act, col, x, y, relSize), dir(d), len(l)
{
}

ArrowItem::~ArrowItem()
{
}

KplItem::ItemTypes ArrowItem::iType() const
{
  return Arrow;
}

void ArrowItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColFrame(color);
    double sav = g->setRelSize(relsiz);
    g->arrow(x0, y0, dir, len, &bRect);
    g->setRelSize(sav);
  }
}

#ifndef KPL_CLASSES_ONLY
void ArrowItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                         KplDoc* m) const
{
  plo->writeEntry("Type", "ARROWITEM");
  DecoItem::writePlo(plo, url, abs, m);
  plo->writeEntry("dir", dir);
  plo->writeEntry("len", len);
}

void ArrowItem::setText(QListViewItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Arrow"));
  KGraph g;
  it->setPixmap(2, g.pixmap(1, color));
  QString s1, s2;
  it->setText(2, s1.sprintf("x = %g cm, y = %g cm, ", x0, y0) +
              i18n("direction") + s2.sprintf(" %g\260", dir));
}

int ArrowItem::editItem(QWidget* parent, KplDoc* m, int)
{
  ArrowDlg dlg(parent, m, this);
  return dlg.exec();
}
#endif

KplItem* ArrowItem::copy() const
{
  return new ArrowItem(*this);
}
