/***************************************************************************
                          ellipseitem.cpp  -  description
                             -------------------
    begin                : Sun Apr 29 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <ksimpleconfig.h>
#include "ellipseitem.h"
#include "kgraph.h"
#ifndef KPL_CLASSES_ONLY
#include <qlistview.h>
#include "rectdlg.h"
#endif

EllipseItem::EllipseItem()
{
  height = 3.0;
}

EllipseItem::EllipseItem(KplNamespace::AutoStruct* aut) :
 RectItem(aut)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto;
}

EllipseItem::EllipseItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut) :
 RectItem(plo, aut)
{
}

EllipseItem::EllipseItem(bool act, int fill, const QString& col,
                         double x, double y, double w, double h,
                         double relSize, double ang) :
 RectItem(act, fill, col, x, y, w, h, relSize, ang)
{
}

EllipseItem::~EllipseItem()
{
}

KplItem::ItemTypes EllipseItem::iType() const
{
  return Ellipse;
}

void EllipseItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColData(color);
    double sav = g->setRelSize(relsiz);
    g->ellipse(x0, y0, width, height, fillStyle, dir, &bRect);
    g->setRelSize(sav);
  }
}

#ifndef KPL_CLASSES_ONLY
void EllipseItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                           KplDoc* m) const
{
  RectItem::writePlo(plo, url, abs, m);
  plo->writeEntry("Type", "ELLIPSEITEM");
}

void EllipseItem::setText(QListViewItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Ellipse"));
  KGraph g;
  it->setPixmap(2, g.pixmap(fillStyle ? -11 : 0, color));
  QString s1, s2;
  it->setText(2, s1.sprintf("x = %g cm, y = %g cm, ", x0, y0) + i18n("size")
              + s2.sprintf(" %g cm x %g cm", width, height));
}

int EllipseItem::editItem(QWidget* parent, KplDoc* m, int)
{
  RectDlg dlg(parent, m, this);
  dlg.setCaption(i18n("Ellipse"));
  return dlg.exec();
}
#endif

KplItem* EllipseItem::copy() const
{
  return new EllipseItem(*this);
}
