/***************************************************************************
                          kpldoubleedit.cpp  -  description
                             -------------------
    begin                : Tue Aug 15 2000
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpldoubleedit.h"
#include <qvalidator.h>

KplDoubleEdit::KplDoubleEdit(double val, QWidget* _parent, char format,
                             int prc) :
 QLineEdit(_parent), frm(format), prec(prc)
{
  validator = new QDoubleValidator::QDoubleValidator(this);
  validator->setDecimals(prc);
  setValidator(validator);
  setValue(val);
}

KplDoubleEdit::KplDoubleEdit(double val, double minVal, double maxVal,
                             QWidget* _parent, char format, int prc) :
 QLineEdit(_parent), frm(format), prec(prc)
{
  validator = new QDoubleValidator::QDoubleValidator(minVal, maxVal, prc, this);
  setValidator(validator);
  setValue(val);
}

KplDoubleEdit::~KplDoubleEdit()
{
}

double KplDoubleEdit::setValue(double val)
{
  setText(QString::number(val, frm, prec));
  return value();
}

double KplDoubleEdit::value()
{
  QString s = text();
  double val = s.toDouble();
  if (validator->bottom() || validator->top())
    val = QMAX(QMIN(val, validator->top()), validator->bottom());
  setText(QString::number(val, frm, prec));
  return val;
}

void KplDoubleEdit::setBottom(double bottom)
{
  validator->setBottom(bottom);
}

void KplDoubleEdit::focusOutEvent(QFocusEvent* e)
{
  value();
  QLineEdit::focusOutEvent(e);
}
