/***************************************************************************
                          linedlg.h  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LINEDLG_H
#define LINEDLG_H

#include <decodlg.h>

class LineItem;

/**
  * Line settings dialog class. Provides a dialog for the settings
  * of a line decoration item.
  * @author Werner Stille
  */
class LineDlg : public DecoDlg
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ld pointer to line item.
   */
  LineDlg(QWidget* parent, KplDoc* model, LineItem* ld);
  /** Destructor. */
  ~LineDlg();

protected:
  /**
   * Copies settings to line item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  LineItem* ld;
  KplSpinBox* symb;
  KplDoubleEdit *eDir, *eLen;

protected slots:
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
