/***************************************************************************
                          rectdlg.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include "brushdlg.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "rectitem.h"
#include "rectdlg.h"

RectDlg::RectDlg(QWidget* _parent, KplDoc* model, RectItem* rd0) :
 DecoDlg(_parent, QString::null, rd0->iType() == KplItem::Rectangle ?
         "SEC-RECT" : "SEC-ELLIPSE", model, rd0, 6), rd(rd0)
{
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel(i18n("Width"), frame), 0, 0);
  grid->addWidget(eWidth = new KplDoubleEdit(rd->width, 0.01, 200.0, frame),
                  0, 1);
  grid->addWidget(new QLabel("cm", frame), 0, 2);
  grid->addWidget(new QLabel(i18n("Height"), frame), 0, 4);
  grid->addWidget(eHeight = new KplDoubleEdit(rd->height, 0.01, 200.0, frame),
                  0, 5);
  grid->addWidget(new QLabel("cm", frame), 0, 6);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addMultiCellLayout(hbox, 1, 1, 1, 6);
  hbox->addWidget(isotropic = new QCheckBox(rd->iType() == KplItem::Rectangle ?
                                            i18n("Square") : i18n("Circle"),
                                            frame));
  hbox->addItem(new QSpacerItem(10, 10, QSizePolicy::Expanding));
  connect(isotropic, SIGNAL(toggled(bool)), SLOT(slotAspect(bool)));
  isotropic->setChecked(rd->width == rd->height);
  grid->addWidget(new QLabel(i18n("Rotation"), frame), 2, 0);
  grid->addWidget(eDir = new KplDoubleEdit(rd->dir, -360.0, 360.0, frame),
                  2, 1);
  grid->addWidget(new QLabel("\260", frame), 2, 2);
  initEntries(3);
  eRelSize->setDisabled(rd->fillStyle);
  lSize->setText(i18n("Line width"));
  grid->addWidget(new QLabel(i18n("Fill pattern"), frame), 5, 4);
  grid->addWidget(fill = new BrushButton(frame, rd->fillStyle), 5, 5);
  connect(fill, SIGNAL(valueChanged(bool)), eRelSize, SLOT(setDisabled(bool)));
}

RectDlg::~RectDlg()
{
}

void RectDlg::getValues(bool ok)
{
  rd->width = eWidth->value();
  rd->height = isotropic->isChecked() ? rd->width : eHeight->value();
  rd->dir = eDir->value();
  rd->fillStyle = fill->value();
  DecoDlg::getValues(ok);
}

void RectDlg::slotAspect(bool iso)
{
  if (iso)
    eHeight->setValue(eWidth->value());
  eHeight->setDisabled(iso);
}

void RectDlg::slotOk()
{
  getValues(true);
}

void RectDlg::slotApply()
{
  getValues(false);
}
