/***************************************************************************
                          residualsdlg.h  -  description
                             -------------------
    begin                : Sun Jul 15 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RESIDUALSDLG_H
#define RESIDUALSDLG_H

#include <kdialogbase.h>

template<class> class QPtrList;
class KplItem;
class KplDoc;

/**
  * Residuals dialog class. Dialog to show a plot of parameter fit residuals.
  * @author Werner Stille
  */
class ResidualsDlg : public KDialogBase
{
   Q_OBJECT
public:
  /**
    * Constructor.
    * @param parent parent widget.
    * @param model pointer to KplDoc model object.
    * @param items list of plot items.
    */
  ResidualsDlg(QWidget* parent, KplDoc* model, QPtrList<KplItem>* items);
  /** Destructor: */
  ~ResidualsDlg();

protected slots:
  /** Prints plot. */
  virtual void slotUser1();
  /** Saves plot. */
  virtual void slotUser2();

protected:
  QPtrList<KplItem>* items;
  KplDoc* m;
};

#endif
