/***************************************************************************
                          symboldlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <klocale.h>
#include "kplspinbox.h"
#include "symboldlg.h"

SymbolButton::SymbolButton(QWidget* _parent, KplSpinBox* sb, bool disable,
                           bool lines) :
 QPushButton(_parent), symb(sb), linesOnly(lines)
{
  setButtonSymbol(symb->value());
  setFixedSize(50, 24);
  if (disable) {
    setDisabled(disable);
    symb->setDisabled(disable);
  }
  connect(symb, SIGNAL(valueChanged(int)), SLOT(setButtonSymbol(int)));
  connect(this, SIGNAL(clicked()), SLOT(slotSymbol()));
}

SymbolButton::~SymbolButton()
{
}

void SymbolButton::setButtonSymbol(int isymb)
{
  QString s;
  if (isymb > 0)
#if KDE_VERSION >= 0x030200
    setPixmap(QPixmap(kapp->iconLoader()->iconPath(s.sprintf("line%i", isymb),
                                                   0)));
#else
    setPixmap(SmallIcon(s.sprintf("line%i", isymb)));
#endif
  else
    if (isymb == -17)
      setPixmap(0);
    else
      setPixmap(SmallIcon(s.sprintf("symb%i", -isymb), 9));
}

void SymbolButton::slotSymbol()
{
  SymbolDlg dlg(parentWidget(), symb, linesOnly);
  dlg.exec();
}

SymbolDlg::SymbolDlg(QWidget* _parent, KplSpinBox* sb0, bool lines) :
 KDialogBase(Plain, i18n(lines ? "Lines" : "Lines and markers"),
 Ok | Cancel, Ok, _parent), sb(sb0), linesOnly(lines)
{
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g1 = new QGroupBox(0, Qt::Vertical,
                                linesOnly ? QString("") : i18n("Lines"), frame);
  bg = new QButtonGroup();
  QRadioButton* r;
  QLabel* l;
  QString s;
  QGridLayout* grid;
  QHBoxLayout* hbox;
  if (linesOnly)
    vbox->addWidget(g1);
  else {
    hbox = new QHBoxLayout(vbox, spacingHint());
    hbox->addWidget(g1);
    QGroupBox* g2 = new QGroupBox(0, Qt::Vertical, i18n("Markers"), frame);
    hbox->addWidget(g2);
    grid = new QGridLayout(g2->layout(), 9, 5, spacingHint());
    for (int i = 17; i >= 0; i--) {
      int ix = 3 * (i / 9);
      int iy = i % 9;
      grid->addWidget(r = new QRadioButton(QString::number(-i), g2),
                      iy, ix + 1);
      bg->insert(r);
      if (i == 17)
        continue;
      grid->addWidget(l = new QLabel(g2), iy, ix);
      l->setPixmap(SmallIcon(s.sprintf("symb%i", i), 9));
    }
    grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding),
                  0, 2);
  }
  grid = new QGridLayout(g1->layout(), 9, 2, spacingHint());
  for (int i = 0; i < 9; i++) {
    grid->addWidget(r = new QRadioButton(QString::number(i + 1), g1), i, 1);
    bg->insert(r);
    grid->addWidget(l = new QLabel(g1), i, 0);
#if KDE_VERSION >= 0x030200
    l->setPixmap(QPixmap(kapp->iconLoader()->iconPath(s.sprintf("line%i",
                                                                i + 1), 0)));
#else
    l->setPixmap(SmallIcon(s.sprintf("line%i", i + 1)));
#endif
  }
  ((QRadioButton*) bg->find(sb->interpretedValue() +
                            (linesOnly ? (-1) : 17)))->setChecked(true);
}

SymbolDlg::~SymbolDlg()
{
  delete bg;
}

void SymbolDlg::slotOk()
{
  sb->setValue(bg->id(bg->selected()) - (linesOnly ? (-1) : 17));
  accept();
}
