/***************************************************************************
                      kstcurvedialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qwidget.h>
#include <qmessagebox.h>

// include files for KDE
#include <kcombobox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstaticdeleter.h>
#include <kmdimainfrm.h>

// application specific includes
#include "kstcurvedialog_i.h"
#include "curveappearancewidget.h"
#include "curveplacementwidget.h"
#include "kst.h"
#include "kst2dplot.h"
#include "kstdatacollection.h"
#include "kstdoc.h"
#include "kstpoint.h"
#include "kstvectordialog_i.h"
#include "kstviewwindow.h"
#include "kstviewobject.h"
#include "vectorselector.h"

#define DIALOGTYPE KstCurveDialogI
#define DTYPE "Curve"
#include "dataobjectdialog.h"

KstCurveDialogI *KstCurveDialogI::_inst = 0L;
static KStaticDeleter<KstCurveDialogI> _cuInst;

KstCurveDialogI *KstCurveDialogI::globalInstance() {
  if (!_inst) {
    _inst = _cuInst.setObject(new KstCurveDialogI);
  }
return _inst;
}


KstCurveDialogI::KstCurveDialogI(QWidget* parent,
                                 const char* name, bool modal, WFlags fl)
  : KstCurveDialog(parent, name, modal, fl) {
  Init();

  connect(_xVector, SIGNAL(newVectorCreated(const QString&)),
          this, SIGNAL(modified()));
  connect(_yVector, SIGNAL(newVectorCreated(const QString&)),
          this, SIGNAL(modified()));
  connect(_xError, SIGNAL(newVectorCreated(const QString&)),
          this, SIGNAL(modified()));
  connect(_yError, SIGNAL(newVectorCreated(const QString&)),
          this, SIGNAL(modified()));

  _xError->provideNoneVector(true);
  _yError->provideNoneVector(true);
}

KstCurveDialogI::~KstCurveDialogI() {
  DP = 0L;
}

KstVCurvePtr KstCurveDialogI::_getPtr(const QString &tagin) {
  KstVCurveList c =
    kstObjectSubList<KstDataObject, KstVCurve>(KST::dataObjectList);

  if ( c.findTag(tagin) == c.end() ) {
    return 0L;
  } else {
    return *c.findTag(tagin);
  }
}

void KstCurveDialogI::updateWindow() {
  _curvePlacement->update();
}

void KstCurveDialogI::_fillFieldsForEdit() {
  if ( DP == 0L ) return; // shouldn't be needed
  _tagName->setText( DP->tagName() );

  _xVector->setSelection(DP->getXVTag());
  _yVector->setSelection(DP->getYVTag());
  _xError->setSelection(DP->getXETag());
  _yError->setSelection(DP->getYETag());

  _curveAppearance->setValue(
    DP->hasLines(), DP->hasPoints(), DP->getColor(),
    DP->Point.getType(), DP->lineWidth(), DP->lineStyle());

  _curvePlacement->hide();

  adjustSize();
  resize(minimumSizeHint());
}

void KstCurveDialogI::_fillFieldsForNew() {
  KstVCurveList curves =
    kstObjectSubList<KstDataObject, KstVCurve>(KST::dataObjectList);

  /* set tag name */
  QString new_label;
  new_label.sprintf("C%d-", signed(curves.count())+1);
  new_label += i18n("<New_Curve>");
  _tagName->setText(new_label);

  /* set the curve placement window  */
  _curvePlacement->update();

  //for some reason the lower widget needs to be shown first to prevent overlapping?
  _curveAppearance->hide();
  _curvePlacement->show();
  _curveAppearance->show();
  _curveAppearance->reset();

  adjustSize();
  resize(minimumSizeHint());
}

void KstCurveDialogI::update() {
  _curvePlacement->update();
  _xVector->update();
  _yVector->update();
  _xError->update();
  _yError->update();
}

bool KstCurveDialogI::new_I() {
  KstWriteLocker ml(&KST::vectorList.lock());
  KstVectorList::Iterator VX, VY;
  KstVectorList::Iterator EX, EY;
  KstVCurvePtr curve;

  if (_xVector->selectedVector().isEmpty() ||
      _yVector->selectedVector().isEmpty()) {
    KMessageBox::sorry(0L, i18n("New curve not made: define vectors first."));
    return false;
  }

  /* find VX and VY */
  VX = KST::vectorList.findTag(_xVector->selectedVector());
  VY = KST::vectorList.findTag(_yVector->selectedVector());
  EX = KST::vectorList.findTag(_xError->selectedVector());
  EY = KST::vectorList.findTag(_yError->selectedVector());
  if (VX == KST::vectorList.end() || VY == KST::vectorList.end()) {
    kdFatal() << "Bug in kst: the XVector field in plotDialog refers to "
              << "a non existant vector...." << endl;
  }

  KstReadLocker rl1(*VX), rl2(*VY);

  QString tag_name = _tagName->text();
  tag_name.replace(i18n("<New_Curve>"), (*VY)->tagName());

  /* verify that the curve name is unique */
  if (KST::dataTagNameNotUnique(tag_name)) {
    _tagName->setFocus();
    return false;
  }

  /* create the curve */
  curve = new KstVCurve(tag_name, *VX, *VY,
                        EX != KST::vectorList.end() ? *EX : KstVectorPtr(0L),
                        EY != KST::vectorList.end() ? *EY : KstVectorPtr(0L),
                        _curveAppearance->color());
  curve->setHasPoints(_curveAppearance->showPoints());
  curve->setHasLines(_curveAppearance->showLines());
  curve->setLineWidth(_curveAppearance->lineWidth());
  curve->setLineStyle(_curveAppearance->lineStyle());
  curve->Point.setType(_curveAppearance->pointType());

  Kst2DPlotPtr plot;
  KstViewWindow *w = dynamic_cast<KstViewWindow*>(KstApp::inst()->findWindow(_curvePlacement->_plotWindow->currentText()));
  if (!w) {
    QString newName = KST::suggestWinName();
    QString n = KstApp::inst()->newWindow(newName);
    w = static_cast<KstViewWindow*>(KstApp::inst()->findWindow(n));
  }
  if (w) {
    if (_curvePlacement->existingPlot()) {
      /* assign curve to plot */
      plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(_curvePlacement->plotName()).data());
      if (plot) {
        plot->addCurve(curve.data());
        w->view()->paint(P_DATA);
      }
    }

    if (_curvePlacement->newPlot()) {
      /* assign curve to plot */
      QString name = w->createPlot<Kst2DPlot>(KST::suggestPlotName());
      plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(name).data());
      if (_curvePlacement->reGrid()) {
        w->view()->cleanup(_curvePlacement->columns());
      }
      if (plot) {
        _curvePlacement->update();
        _curvePlacement->setCurrentPlot(plot->tagName());
        plot->addCurve(curve.data());
        plot->GenerateDefaultLabels();
        w->view()->paint(P_DATA);
      }
    }
  }

  KST::dataObjectList.lock().writeLock();
  KST::dataObjectList.append(curve.data());
  KST::dataObjectList.lock().writeUnlock();

  curve = 0L; // drop the reference
  emit modified();
  return true;
}

bool KstCurveDialogI::edit_I() {

  /* verify that the curve name is unique */
  if (_tagName->text() != DP->tagName()) {
    if (KST::dataTagNameNotUnique(_tagName->text())) {
      _tagName->setFocus();
      return false;
    }
  }

  DP->setTagName(_tagName->text());

  { // leave this scope here to destroy the iterator
    KstReadLocker ml(&KST::vectorList.lock());
    KstVectorList::Iterator i = KST::vectorList.findTag(_xVector->selectedVector());
    if (i != KST::vectorList.end())
      DP->setXVector(*i);

    i = KST::vectorList.findTag(_yVector->selectedVector());
    if (i != KST::vectorList.end())
      DP->setYVector(*i);

    i = KST::vectorList.findTag(_xError->selectedVector());
    DP->setXError(*i);

    i = KST::vectorList.findTag(_yError->selectedVector());
    DP->setYError(*i);
  }

  DP->setColor(_curveAppearance->color());
  DP->setHasPoints(_curveAppearance->showPoints());
  DP->setHasLines(_curveAppearance->showLines());
  DP->setLineWidth(_curveAppearance->lineWidth());
  DP->setLineStyle(_curveAppearance->lineStyle());
  DP->Point.setType(_curveAppearance->pointType());

  DP->update(-1);
  emit modified();

  return true;
}


#include "kstcurvedialog_i.moc"
//vim: ts=2 sw=2 et
