/***************************************************************************
                       ksteqdialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qwidget.h>
#include <qmessagebox.h>

// include files for KDE
#include <kcombobox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstaticdeleter.h>
#include <kmdimainfrm.h>

// application specific includes
#include "ksteqdialog_i.h"
#include "curveappearancewidget.h"
#include "curveplacementwidget.h"
#include "kst.h"
#include "kst2dplot.h"
#include "kstdoc.h"
#include "kstdatacollection.h"
#include "kstviewwindow.h"
#include "scalarselector.h"
#include "vectorselector.h"


#define DIALOGTYPE KstEqDialogI
#define DTYPE "Equation"
#include "dataobjectdialog.h"

KstEqDialogI *KstEqDialogI::_inst = 0L;
static KStaticDeleter<KstEqDialogI> _eqInst;

KstEqDialogI *KstEqDialogI::globalInstance() {
  if (!_inst) {
    _inst = _eqInst.setObject(new KstEqDialogI);
  }
  return _inst;
}


KstEqDialogI::KstEqDialogI(QWidget* parent, const char* name, bool modal, WFlags fl)
: KstEqDialog(parent, name, modal, fl) {
  Init();

  connect(_vectors, SIGNAL(newVectorCreated(const QString&)), this, SIGNAL(modified()));
  connect(_xVectors, SIGNAL(newVectorCreated(const QString&)), this, SIGNAL(modified()));
  connect(_scalars, SIGNAL(newScalarCreated()), this, SIGNAL(modified()));
}

KstEqDialogI::~KstEqDialogI() {
  DP = 0L;
}

KstEquationCurvePtr KstEqDialogI::_getPtr(const QString &tagin) {
  KstEquationCurveList c =
    kstObjectSubList<KstDataObject, KstEquationCurve>(KST::dataObjectList);

  if ( c.findTag(tagin) == c.end() ) {
    return 0L;
  } else {
    return *c.findTag(tagin);
  }
}

void KstEqDialogI::updateWindow() {
  _curvePlacement->update();
}

void KstEqDialogI::_fillFieldsForEdit() {
  if ( DP == 0L ) return; // shouldn't be needed
  _tagName->setText( DP->tagName() );

  Equation->setText(DP->equation());

  if (DP->isXStatic()) {
    GenerateX->setChecked(true);
    UseExistingVector->setChecked(false);
  } else {
    GenerateX->setChecked(false);
    UseExistingVector->setChecked(true);
    DoInterpolation->setChecked(DP->doInterp());
    if (DP->vX()) {
      _xVectors->setSelection(DP->vX()->tagName());
    }
  }

  if (DP->vX()) {
    N->setValue(DP->vX()->sampleCount());
    XMin->setText(QString::number(DP->vX()->min()));
    XMax->setText(QString::number(DP->vX()->max()));
  }


  _curveAppearance->setValue(
    DP->hasLines(), DP->hasPoints(), DP->getColor(),
    DP->Point.getType(), DP->lineWidth(), DP->lineStyle());

  _curvePlacement->hide();

  adjustSize();
  resize(minimumSizeHint());
}

void KstEqDialogI::_fillFieldsForNew() {
  KstEquationCurveList eqs =
    kstObjectSubList<KstDataObject, KstEquationCurve>(KST::dataObjectList);

  /* set tag name */
  QString new_label;
  new_label.sprintf("Eq%d-", signed(eqs.count())+1);
  new_label += i18n("<New_Equation>");
  _tagName->setText(new_label);

  /* set the curve placement window  */
  _curvePlacement->update();

  Equation->clear();

  //for some reason the lower widget needs to be shown first to prevent overlapping?
  _curveAppearance->hide();
  _curvePlacement->show();
  _curveAppearance->show();
  _curveAppearance->reset();

  adjustSize();
  resize(minimumSizeHint());
}

void KstEqDialogI::update() {
  _curvePlacement->update();
  _vectors->update();
  _xVectors->update();
  _scalars->update();
}

bool KstEqDialogI::new_I() {
  KstEquationCurvePtr eq;
  int n;
  double x0, x1;
  bool ok;

  QString tag_name = _tagName->text();
  tag_name.replace(i18n("<New_Equation>"), Equation->text());

  /* verify that the curve name is unique */
  if (KST::dataTagNameNotUnique(tag_name)) {
    _tagName->setFocus();
    return false;
  }

  if ( !_checkEntries() ) return false;

  if (UseExistingVector->isChecked()) {
    KST::vectorList.lock().readLock();
    /* find *V */
    KstVectorList::Iterator i =
      KST::vectorList.findTag(_xVectors->selectedVector());
    if (i == KST::vectorList.end()) {
      kdFatal() << "Bug in kst: the Vector field in plotDialog (Eq) "
                << "refers to a non-existent vector..." << endl;
    }
    KST::vectorList.lock().readUnlock();

    /** Create the equation here */
    eq = new KstEquationCurve(tag_name, Equation->text(),
                              *i, DoInterpolation->isChecked(),
                              _curveAppearance->color());
  } else {
    n = N->value();
    x0 = XMin->text().toDouble(&ok);
    x1 = XMax->text().toDouble(&ok);
    eq = new KstEquationCurve(tag_name, Equation->text(),
                              x0, x1, n, _curveAppearance->color());
  }

  if (!eq->isValid()) {
    eq = 0L;
    KMessageBox::sorry(0L, i18n("There is a syntax error in the equation "
                                "you entered.  Please fix it."));
    return false;
  }

  eq->setHasPoints(_curveAppearance->showPoints());
  eq->setHasLines(_curveAppearance->showLines());
  eq->setLineWidth(_curveAppearance->lineWidth());
  eq->setLineStyle(_curveAppearance->lineStyle());
  eq->Point.setType(_curveAppearance->pointType());

  Kst2DPlotPtr plot;
  KstViewWindow *w = dynamic_cast<KstViewWindow*>(KstApp::inst()->findWindow(_curvePlacement->_plotWindow->currentText()));
  if (!w) {
    QString newName = KST::suggestWinName();
    QString n = KstApp::inst()->newWindow(newName);
    w = static_cast<KstViewWindow*>(KstApp::inst()->findWindow(n));
  }
  if (w) {
    if (_curvePlacement->existingPlot()) {
      /* assign curve to plot */
      plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(_curvePlacement->plotName()).data());
      if (plot) {
        plot->addCurve(eq.data());
        w->view()->paint(P_DATA);
      }
    }

    if (_curvePlacement->newPlot()) {
      /* assign curve to plot */
      QString name = w->createPlot<Kst2DPlot>(KST::suggestPlotName());
      if (_curvePlacement->reGrid()) {
        w->view()->cleanup(_curvePlacement->columns());
      }
      plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(name).data());
      if (plot) {
        _curvePlacement->update();
        _curvePlacement->setCurrentPlot(plot->tagName());
        plot->addCurve(eq.data());
        plot->GenerateDefaultLabels();
        w->view()->paint(P_DATA);
      }
    }
  }

  KST::dataObjectList.lock().writeLock();
  KST::dataObjectList.append(eq.data());
  KST::dataObjectList.lock().writeUnlock();

  eq = 0L; // drop the reference before we update
  emit modified();
  return true;
}

bool KstEqDialogI::_checkEntries() {
  if (UseExistingVector->isChecked()) {
    if (_xVectors->selectedVector().isEmpty()) {
      KMessageBox::sorry(0L, i18n("Cannot use selected vector unless an "
                                  "X vector is defined first."));
      return false;
    }
  } else {
    int n;
    double x0, x1;
    bool ok;

    n = N->value();
    if (n < 2) {
      KMessageBox::sorry(0L, i18n("The equation must be evaluated at more "
                                  "than one point.  Increase Num Samples."));
      return false;
    }
    x0 = XMin->text().toDouble(&ok);
    if (!ok) {
      KMessageBox::sorry(0L, i18n("The text you entered for the minimum X "
                                  "value is not a number."));
      return false;
    }
    x1 = XMax->text().toDouble(&ok);
    if (!ok) {
      KMessageBox::sorry(0L, i18n("The text you entered for the maximum X "
                                  "value is not a number."));
      return false;
    }

    if (x0 == x1) {
      KMessageBox::sorry(0L, i18n("The minimum and maximum X range cannot "
                                  "be equal."));
      return false;
    }
  }
  return true;
}

bool KstEqDialogI::edit_I() {

  /* verify that the curve name is unique */
  if (_tagName->text() != DP->tagName()) {
    if (KST::dataTagNameNotUnique(_tagName->text())) {
      return false;
    }
  }

  DP->setTagName(_tagName->text());

  DP->setColor(_curveAppearance->color());
  DP->setHasPoints(_curveAppearance->showPoints());
  DP->setHasLines(_curveAppearance->showLines());
  DP->setLineWidth(_curveAppearance->lineWidth());
  DP->setLineStyle(_curveAppearance->lineStyle());
  DP->Point.setType(_curveAppearance->pointType());

  if ( !_checkEntries() ) return false;

  if (UseExistingVector->isChecked()) {
    KST::vectorList.lock().readLock();
    /* find *V */
    KstVectorList::Iterator i =
      KST::vectorList.findTag(_xVectors->selectedVector());
    if (i == KST::vectorList.end()) {
      kdFatal() << "Bug in kst: the Vector field in plotDialog (Eq) "
                << "refers to a non existant vector..." << endl;
    }
    KST::vectorList.lock().readUnlock();

    DP->setExistingXVector(*i, DoInterpolation->isChecked());
  } else {
    bool ok;
    int n = N->value();
    double x0 = XMin->text().toDouble(&ok);
    double x1 = XMax->text().toDouble(&ok);
    DP->setStaticXVector(x0, x1, n);
  }

  DP->setEquation(Equation->text());
  if (!DP->isValid()) {
    KMessageBox::sorry(0L, i18n("There is a syntax error in the equation "
                                "you entered.  Please fix it."));
    return false;
  }

  DP->update();

  emit modified();

  return true;
}

#include "ksteqdialog_i.moc"
// vim: ts=2 sw=2 et
