/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

void DataWizard::init() {
    KST::vectorDefaults.sync();
    QString default_source = KST::vectorDefaults.dataSource();
    _url->setMode(KFile::File | KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly);
    _url->setURL(default_source);

    sourceChanged(default_source);

    connect(_url, SIGNAL(textChanged(const QString&)), this, SLOT(sourceChanged(const QString&)));

    setAppropriate(_pageFilters, false);
    setIcon(BarIcon("kst_datawizard"));

    _kstDataRange->update();
    _kstFFTOptions->update();

    _newWindowName->setText("W?");

    //setNextEnabled(_pageDataSource, false);
    setNextEnabled(_pageVectors, false);
    setNextEnabled(_pageFilters, true);
    setFinishEnabled(_pagePlot, true);

    connect(finishButton(), SIGNAL(clicked()), this, SLOT(finished()));

    // No help button
    setHelpEnabled(_pageDataSource, false);
    setHelpEnabled(_pageVectors, false);
    setHelpEnabled(_pageFilters, false);
    setHelpEnabled(_pagePlot, false);
    _newFilter->setEnabled(false);
    _newFilter->hide(); // FIXME: implement this
}


bool DataWizard::xVectorOk() {
    QString txt = _xVector->currentText();

    for (int i = 0; i < _xVector->count(); ++i) {
	if (_xVector->text(i) == txt) {
	    return true;
	}
    }
    return false;
}


bool DataWizard::yVectorsOk() {
    QListViewItemIterator it(_vectors);

    while (it.current()) {
	QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	if (i->isOn()) {
	    return true;
	}
	++it;
    }

    return false;
}


void DataWizard::xChanged( const QString & txt )
{
    bool found = false;

    for (int i = 0; i < _xVector->count(); ++i) {
	if (_xVector->text(i) == txt) {
	    found = true;
	    break;
	}
    }

    setNextEnabled(_pageVectors, found && yVectorsOk());
}


void DataWizard::sourceChanged( const QString &txt ) {
    bool ok = false;

    if (!txt.isEmpty()) {
	QString file = txt;
	if (file.startsWith("file:")) {
	    file.remove(0, 5);
	}
	KstDataSourcePtr ds = *KST::dataSourceList.findFileName(file);

	if (!ds && file != "stdin" && file != "-") { // FIXME: deal with stdin properly
	    ds = KstDataSource::loadSource(file);
	    if (ds) {
		KST::dataSourceList.lock().writeLock();
		KST::dataSourceList.append(ds);
		KST::dataSourceList.lock().writeUnlock();
	    }
	}

	if (ds && _ds == ds) {
	    return;
	}

	_ds = ds;

	_vectors->clear();
	_xVector->clear();

	if (_ds) {
	    ok = true;
	    QStringList fl = _ds->fieldList();
	    _xVector->insertStringList(fl);
	    _xVector->completionObject()->insertItems(fl);
	    _xVector->setEditable(!_ds->fieldListIsComplete());
	    for (QStringList::ConstIterator it = fl.begin(); it != fl.end(); ++it) {
		new QCheckListItem(_vectors, *it, QCheckListItem::CheckBox);
	    }
	    KST::vectorDefaults.sync();
	    QString defaultX = KST::vectorDefaults.wizardXVector();
	    if (defaultX == "INDEX" || fl.contains(defaultX)) {
		_xVector->setCurrentText(defaultX);
	    }
	}
    } else if (!_ds) {
	setNextEnabled(_pageDataSource, false);
	return;
    } else {
	setNextEnabled(_pageDataSource, false);
	_ds = 0L; // deref
    }
    setNextEnabled(_pageVectors, xVectorOk() && yVectorsOk());
    setNextEnabled(_pageDataSource, ok);
}


void DataWizard::fieldListChanged()
{
    bool ok = yVectorsOk();
    _uncheckAll->setEnabled(ok);
    setNextEnabled(_pageVectors, ok && xVectorOk());
}


void DataWizard::showPage( QWidget *page )
{
    if (page == _pageVectors) {
	_vectorReduction->setFocus();
    } else if (page == _pageFilters) {
	QString save = _filterList->currentText();
	_filterList->clear();
    } else if (page == _pagePlot) {
	//
	// check for sufficient memory...
	//
	unsigned long memoryRequested = 0, memoryAvailable = 1024*1024*1024; // 1GB
#ifdef HAVE_LINUX
	meminfo();
	memoryAvailable = S(kb_main_free + kb_main_buffers + kb_main_cached);
#endif
	if (_kstDataRange->ReadToEnd->isChecked()) {
	    int removeSamples = _kstDataRange->DoSkip->isChecked() ? _kstDataRange->Skip->value() : 0;
	    memoryRequested += (_ds->frameCount(_xVector->currentText()) - removeSamples)*_ds->samplesPerFrame(_xVector->currentText())*sizeof(double);
	} else {
	    memoryRequested += _kstDataRange->N->value()*_ds->samplesPerFrame(_xVector->currentText())*sizeof(double);
	}

	{
	    QListViewItemIterator it(_vectors);
	    while (it.current()) {
		QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
		if (i->isOn()) {
		    QString field = it.current()->text(0);
		    if (_kstDataRange->ReadToEnd->isChecked()) {
			int removeSamples = _kstDataRange->DoSkip->isChecked() ? _kstDataRange->Skip->value() : 0;
			memoryRequested += (_ds->frameCount(field) - removeSamples)*_ds->samplesPerFrame(field)*sizeof(double);
		    } else {
			memoryRequested += _kstDataRange->N->value()*_ds->samplesPerFrame(field)*sizeof(double);
		    }
		}
		++it;
	    }
	}

	if (memoryRequested > memoryAvailable) {
	    KMessageBox::sorry(this, i18n("You requested to read in %1 MB of data but it seems that you only have approximately %2 MB of usable memory available.  Please load less data.").arg(memoryRequested/(1024*1024)).arg(memoryAvailable/(1024*1024)));
	    return;
	}

	KST::vectorDefaults.setWizardXVector(_xVector->currentText());
	KST::vectorDefaults.sync();

	// count the vectors we are about to make, so we can guess defaults
	int n_curves = 0;
	QListViewItemIterator it(_vectors);
	while (it.current()) {
	    QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	    if (i->isOn()) {
		n_curves++;
	    }
	    ++it;
	}

	// set window and plot defaults based on some guesses....
	if (_radioButtonPlotDataPSD->isChecked()) { // plotting both psds and XY plots
	    _newWindows->setEnabled(true);
	    if (n_curves > 1) {
		_newWindows->setChecked(true);
	    } else {
		_newWindow->setChecked(true);
	    }
	} else { // just plotting XY or PSD
	    _newWindows->setEnabled(false);
	    _currentWindow->setChecked(true);
	}
	_multiplePlots->setChecked(true);

	updateWindowBox();
	updatePlotBox();
    }

    QWizard::showPage(page);
}


void DataWizard::updateWindowBox()
{
    KstApp *app = KstApp::inst();
    KMdiIterator<KMdiChildView*> *it = app->createIterator();

    _windowName->clear();
    while (it->currentItem()) {
	KstViewWindow *v = dynamic_cast<KstViewWindow*>(it->currentItem());
	if (v) {
	    _windowName->insertItem(v->caption());
	}
	it->next();
    }
    app->deleteIterator(it);

    _existingWindow->setEnabled(_windowName->count() > 0);
    _currentWindow->setEnabled(_windowName->count() > 0 && KstApp::inst()->activeWindow());

    if (!_windowGroup->selected() || !_windowGroup->selected()->isEnabled()) {
	_newWindow->setChecked(true);
    }
}


void DataWizard::updatePlotBox()
{
    QString psave = _existingPlotName->currentText();
    KstApp *app = KstApp::inst();

    _existingPlotName->clear();

    if (_newWindow->isChecked() || _newWindows->isChecked()) {
	_onePlot->setEnabled(true);
	_multiplePlots->setEnabled(true);
	_cycleThrough->setEnabled(true);
	_plotNumber->setEnabled(_cycleThrough->isChecked());
	_cycleExisting->setEnabled(false);
	_existingPlot->setEnabled(false);
	_existingPlotName->setEnabled(false);
    } else {
	KstViewWindow *v;
	if (_currentWindow->isChecked()) {
	    v = static_cast<KstViewWindow*>(app->activeWindow());
	} else {
	    v = static_cast<KstViewWindow*>(app->findWindow(_windowName->currentText()));
	}

	Kst2DPlotList plots;
	if (v) {
	    plots += v->view()->findChildrenType<Kst2DPlot>();
	}

	for (Kst2DPlotList::Iterator i = plots.begin(); i != plots.end(); ++i) {
	    _existingPlotName->insertItem((*i)->tagName());
	}

	bool havePlots = _existingPlotName->count() > 0;
	_onePlot->setEnabled(true);
	_multiplePlots->setEnabled(true);
	_cycleThrough->setEnabled(true);
	_plotNumber->setEnabled(_cycleThrough->isChecked());
	_cycleExisting->setEnabled(havePlots);
	_existingPlot->setEnabled(havePlots);
	_existingPlotName->setEnabled(havePlots && _existingPlot->isChecked());
    }

    if (!_plotGroup->selected()->isEnabled()) {
	_onePlot->setChecked(true);
    }

    if (_existingPlot->isEnabled() && _existingPlotName->listBox()->findItem(psave)) {
	_existingPlotName->setCurrentText(psave);
    }
}


void DataWizard::uncheckAll()
{
    QListViewItemIterator it(_vectors);
    while (it.current()) {
	QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	i->setOn(false);
	++it;
    }

    _uncheckAll->setEnabled(false);
    setNextEnabled(_pageVectors, false);
}


void DataWizard::vectorSubset(const QString& filter)
{
    QListViewItem *after = 0L;
    _vectors->clearSelection();
    _vectors->setSorting(2, true); // Qt 3.1 compat
    QRegExp re(filter, true /* case insensitive */, true /* wildcard */);
    QListViewItemIterator it(_vectors);
    while (it.current()) {
	QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	++it;
	if (re.exactMatch(i->text(0))) {
	    if (!after) {
		_vectors->takeItem(i);
		_vectors->insertItem(i);
	    } else {
		i->moveItem(after);
	    }
	    after = i;
	    i->setSelected(true);
	}
    }
}


void DataWizard::checkSelected()
{
    bool ok = false;
    QListViewItemIterator it(_vectors);
    while (it.current()) {
	QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	if (i->isSelected()) {
	    i->setOn(true);
	    i->setSelected(false);
	    ok = true;
	}
	++it;
    }

    _vectorReduction->setText(QString::null);

    if (ok) {
	_uncheckAll->setEnabled(true);
	setNextEnabled(_pageVectors, xVectorOk());
    }
}


void DataWizard::newFilter()
{
  // FIXME
}


void DataWizard::finished()
{
    KstApp *app = KstApp::inst();
    KstVectorList l;
    QString name = QString("V%1-%2").arg(KST::vectorList.count()).arg(_xVector->currentText());
    uint n_curves = 0;
    uint n_steps = 0;
    int ptype = 0;
    int prg = 0;

    {
	QListViewItemIterator it(_vectors);
	while (it.current()) {
	    QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	    if (i->isOn()) {
		n_steps++;
	    }
	    ++it;
	}
    }

    n_steps += 1; // for the creation of the x-vector...
    prg = 0;
    app->slotUpdateProgress(n_steps, prg, i18n("Creating vectors..."));

    //
    // create the x-vector...
    //
    KstVectorPtr xv = new KstRVector(_ds, _xVector->currentText(),
	    name, _kstDataRange->CountFromEnd->isChecked() ? -1 : _kstDataRange->F0->value(),
	    _kstDataRange->ReadToEnd->isChecked() ? -1 : _kstDataRange->N->value(),
	    _kstDataRange->DoSkip->isChecked() ? _kstDataRange->Skip->value() : 0, _kstDataRange->DoSkip->isChecked(),
	    _kstDataRange->DoFilter->isChecked());
    KST::addVectorToList(xv);
    app->slotUpdateProgress(n_steps, ++prg, i18n("Creating vectors..."));

    //
    // create the y-vectors...
    //
    {
	QListViewItemIterator it(_vectors);
	while (it.current()) {
	    QCheckListItem *i = static_cast<QCheckListItem*>(it.current());
	    if (i->isOn()) {
		name = QString("V%1-%2").arg(KST::vectorList.count()).arg(it.current()->text(0));
		KstVectorPtr v = new KstRVector(_ds, it.current()->text(0), name,
			_kstDataRange->CountFromEnd->isChecked() ? -1 : _kstDataRange->F0->value(),
			_kstDataRange->ReadToEnd->isChecked() ? -1 : _kstDataRange->N->value(),
			_kstDataRange->DoSkip->isChecked() ? _kstDataRange->Skip->value() : 0, _kstDataRange->DoSkip->isChecked(),
			_kstDataRange->DoFilter->isChecked());
		KST::addVectorToList(v);
		l.append(v);
		n_curves++;
		app->slotUpdateProgress(n_steps, ++prg, i18n("Creating vectors..."));
	    }
	    ++it;
	}
    }

    //
    // get a pointer to the first window...
    //
    QString newName;
    KstViewWindow *w;
    if (_newWindow->isChecked() || _newWindows->isChecked()) {
	newName = _newWindowName->text();
	if (newName=="W?") newName = KST::suggestWinName();
	QString n = app->newWindow(newName);
	w = static_cast<KstViewWindow*>(app->findWindow(n));
    } else if (_currentWindow->isChecked()) {
	w = static_cast<KstViewWindow*>(app->activeWindow());
    } else {
	w = static_cast<KstViewWindow*>(app->findWindow(_windowName->currentText()));
    }

    if (!w) {
	return;
    }

    //
    // create the necessary plots...
    //
    app->slotUpdateProgress(0, 0, i18n("Creating plots..."));
    KstViewObjectList plots;
    bool relayout = true;
    if (_onePlot->isChecked()) {
	Kst2DPlotPtr p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(w->createPlot<Kst2DPlot>(KST::suggestPlotName())).data());
	plots.append(p.data());
	if (_radioButtonPlotDataPSD->isChecked()) {
	    if (_newWindows->isChecked()) {
		newName = newName+"-PSD";
		QString n = app->newWindow(newName);
		w = static_cast<KstViewWindow*>(app->findWindow(n));
	    }
	    Kst2DPlotPtr p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(w->createPlot<Kst2DPlot>(KST::suggestPlotName())).data());
	    plots.append(p.data());
	}
    } else if (_multiplePlots->isChecked()) {
	Kst2DPlotPtr p;
	if (_radioButtonPlotDataPSD->isChecked()) {
	    for (uint i = 0; i < l.count(); ++i) {
		p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(w->createPlot<Kst2DPlot>(KST::suggestPlotName())).data());
		plots.append(p.data());
	    }
	    if (_newWindows->isChecked()) {
		newName = newName+"-PSD";
		QString n = app->newWindow(newName);
		w = static_cast<KstViewWindow*>(app->findWindow(n));
	    }
	}
	for (uint i = 0; i < l.count(); ++i) {
	    p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(w->createPlot<Kst2DPlot>(KST::suggestPlotName())).data());
	    plots.append(p.data());
	}
    } else if (_existingPlot->isChecked()) {
	Kst2DPlotPtr p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(_existingPlotName->currentText()).data());
	plots.append(p.data());
	relayout = false;
    } else if (_cycleExisting->isChecked()) {
	Kst2DPlotList pl = QDeepCopy<Kst2DPlotList>(w->view()->findChildrenType<Kst2DPlot>());
	for (Kst2DPlotList::Iterator i = pl.begin(); i != pl.end(); ++i) {
	    plots += (*i).data();
	}
	relayout = false;
    } else { /* cycle */
	Kst2DPlotPtr p;
	if (_radioButtonPlotDataPSD->isChecked()) {
	    for (int i = 0; i < _plotNumber->value(); ++i) {
		p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(w->createPlot<Kst2DPlot>(KST::suggestPlotName())).data());
		plots.append(p.data());
	    }
	    if (_newWindows->isChecked()) {
		QString n = app->newWindow(newName+"-PSD");
		w = static_cast<KstViewWindow*>(app->findWindow(n));
	    }
	}
	for (int i = 0; i < _plotNumber->value(); ++i) {
	    p = dynamic_cast<Kst2DPlot*>(w->view()->findChild(w->createPlot<Kst2DPlot>(KST::suggestPlotName())).data());
	    plots.append(p.data());
	}
    }

    //
    // create the data curves...
    //
    app->slotUpdateProgress(0, 0, i18n("Creating curves..."));
    KstViewObjectList::Iterator pit = plots.begin();
    for (KstVectorList::Iterator it = l.begin(); it != l.end(); ++it) {
	if (_radioButtonPlotData->isChecked() || _radioButtonPlotDataPSD->isChecked()) {
	    name = KST::suggestCurveName((*it)->tagName());
	    KstBaseCurvePtr c = new KstVCurve(name, xv, *it, 0L, 0L,
		    KstColorSequence::next(static_cast<Kst2DPlot*>((*pit).data())->backgroundColor()));
	    if (_drawBoth->isChecked()) {
		c->setHasPoints(true);
		c->Point.setType(ptype++ % KSTPOINT_MAXTYPE);
		c->setHasLines(true);
	    } else if (_drawLines->isChecked()) {
		c->setHasPoints(false);
		c->setHasLines(true);
	    } else {
		c->setHasPoints(true);
		c->Point.setType(ptype++ % KSTPOINT_MAXTYPE);
		c->setHasLines(false);
	    }
	    KST::dataObjectList.lock().writeLock();
	    KST::dataObjectList.append(KstDataObjectPtr(c));
	    KST::dataObjectList.lock().writeUnlock();
	    static_cast<Kst2DPlot*>((*pit).data())->addCurve(c);
	    if (!_onePlot->isChecked()) { // change plots if we are not onePlot...
		if (_radioButtonPlotDataPSD->isChecked()) { // if xy and psd
		    ++pit;
		    if (plots.findIndex(*pit) >= (int)plots.count()/2) {
			pit = plots.begin();
		    }
		} else if (++pit == plots.end()) {
		    pit = plots.begin();
		}
	    }
	}
    }

    if (_onePlot->isChecked()) { // if we are one plot, now we can move to the psd plot
	if (++pit == plots.end()) { // if _newWindows is not checked, there will not be another.
	    pit = plots.begin();
	}
    } else if (_radioButtonPlotDataPSD->isChecked()) {
	pit = plots.at(plots.count()/2);
    }

    //
    // create the PSDs...
    //
    for (KstVectorList::Iterator it = l.begin(); it != l.end(); ++it) {
	if (_radioButtonPlotPSD->isChecked() || _radioButtonPlotDataPSD->isChecked()) {
	    if ((*it)->length() > 0) {
	        name = KST::suggestPSDName((*it)->tagName());

		KstBaseCurvePtr c = new KstPSDCurve(name, *it,
			_kstFFTOptions->SampRate->text().toDouble(),
			_kstFFTOptions->Interleaved->isChecked(),
			_kstFFTOptions->FFTLen->text().toInt(),
			_kstFFTOptions->Apodize->isChecked(),
			_kstFFTOptions->RemoveMean->isChecked(),
			_kstFFTOptions->VectorUnits->text(),
			_kstFFTOptions->RateUnits->text(),
			KstColorSequence::next(static_cast<Kst2DPlot*>((*pit).data())->backgroundColor()));
		if (_drawBoth->isChecked()) {
		    c->setHasPoints(true);
		    c->Point.setType(ptype++ % KSTPOINT_MAXTYPE);
		    c->setHasLines(true);
		} else if (_drawLines->isChecked()) {
		    c->setHasPoints(false);
		    c->setHasLines(true);
		} else {
		    c->setHasPoints(true);
		    c->Point.setType(ptype++ % KSTPOINT_MAXTYPE);
		    c->setHasLines(false);
		}
		KST::dataObjectList.lock().writeLock();
		KST::dataObjectList.append(KstDataObjectPtr(c));
		KST::dataObjectList.lock().writeUnlock();
		static_cast<Kst2DPlot*>((*pit).data())->addCurve(c);
		if (!_onePlot->isChecked()) { // change plots if we are not onePlot...
		    if (++pit == plots.end()) {
			pit = plots.begin();
		    }
		}
	    }
	}
    }

    //
    // legends and labels...
    //
    bool xl = _xAxisLabels->isChecked();
    bool yl = _yAxisLabels->isChecked();
    bool tl = _plotTitles->isChecked();

    pit = plots.begin();
    while (pit != plots.end()) {
	Kst2DPlotPtr pp = static_cast<Kst2DPlot*>((*pit).data());
	pp->GenerateDefaultLabels();
	if (!xl) {
	    pp->setXLabel(QString::null);
	}
	if (!yl) {
	    pp->setYLabel(QString::null);
	}
	if (!tl) {
	    pp->setTopLabel(QString::null);
	}
	if (_legendsOn->isChecked()) {
	    pp->Legend->setShow(true);
	    pp->Legend->setFront(true);
	} else if (_legendsOff->isChecked()) {
	    pp->Legend->setShow(false);
	} else if (_legendsAuto->isChecked()) {
	    if (pp->Curves.count() > 1) {
		pp->Legend->setShow(true);
		pp->Legend->setFront(true);
	    }
	}

	++pit;
    }

    if (relayout) {
	w->view()->cleanup(QMAX(w->view()->columns(), signed(sqrt(plots.count()))));
    }
    w->view()->paint(P_DATA);
    app->slotUpdateProgress(0, 0, QString::null);
}


void DataWizard::applyFiltersChecked( bool on )
{
    setAppropriate(_pageFilters, on);
}


void DataWizard::enableXEntries()
{
    _xVector->setEnabled(true);
    _xvectLabel->setEnabled(true);
}


void DataWizard::disableXEntries()
{
    _xVector->setEnabled(false);
    _xvectLabel->setEnabled(false);
}


void DataWizard::enablePSDEntries()
{
    _kstFFTOptions->setEnabled(true);
}


void DataWizard::disablePSDEntries()
{
    _kstFFTOptions->setEnabled(false);
}


void DataWizard::_search()
{
    QString s = _vectorReduction->text();
    if (!s.isEmpty()) {
	if (s[0] != '*') {
	    s = "*" + s;
	}
	if (s[s.length()-1] != '*') {
	    s += "*";
	}
	_vectorReduction->setText(s);
    }
}


void DataWizard::_disableWindowEntries()
{
    _windowGroup->setEnabled(false);
}


void DataWizard::_enableWindowEntries()
{
    _windowGroup->setEnabled(true);
}

// vim: ts=8 sw=4 noet
