/*
   Copyright (C) 2009 The Universtiry of British Columbia
   Simplified for use in Kst

   Copyright (C) 2000-2001 Dawit Alemayehu <adawit@kde.org>
   Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License (LGPL)
   version 2 as published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   RFC 1321 "MD5 Message-Digest Algorithm" Copyright (C) 1991-1992.             // krazy:exclude=copyright
   RSA Data Security, Inc. Created 1991. All rights reserved.

   The KMD5 class is based on a C++ implementation of
   "RSA Data Security, Inc. MD5 Message-Digest Algorithm" by
   Mordechai T. Abzug,  Copyright (c) 1995.  This implementation                // krazy:exclude=copyright
   passes the test-suite as defined in RFC 1321.

   The encoding and decoding utilities in KCodecs with the exception of
   quoted-printable are based on the java implementation in HTTPClient
   package by Ronald Tschalär Copyright (C) 1996-1999.                          // krazy:exclude=copyright

   The quoted-printable codec as described in RFC 2045, section 6.7. is by
   Rik Hemsley (C) 2001.
*/

#ifndef KSTCODECS_H
#define KSTCODECS_H

#define KstBase64 KstCodecs

#include <qcstring.h>
#include <qiodevice.h>
#include "kst_export.h"

namespace KstCodecs
{
  KST_EXPORT QCString base64Encode( const QCString& str, bool insertLFs );
  KST_EXPORT QCString base64Encode( const QByteArray& in, bool insertLFs = false);
  KST_EXPORT void base64Encode( const QByteArray& in, QByteArray& out, bool insertLFs = false );

  KST_EXPORT QCString base64Decode( const QCString& str );
  KST_EXPORT QCString base64Decode( const QByteArray& in );
  KST_EXPORT void base64Decode( const QByteArray& in, QByteArray& out );
};

class KST_EXPORT KstMD5
{
public:

  typedef unsigned char Digest[16];

  KstMD5();
  KstMD5(const char* in, int len = -1);
  KstMD5(const QByteArray& a );
  KstMD5(const QCString& a );

  void update(const char* in, int len = -1) { update(reinterpret_cast<const unsigned char*>(in), len); }
  void update(const unsigned char* in, int len = -1);
  bool update(QIODevice& file);
  void reset();
  QCString hexDigest ();

protected:
  void transform( const unsigned char buffer[64] );
  void finalize();

private:
  KstMD5(const KstMD5& u);
  KstMD5& operator=(const KstMD5& md);

  void init();
  void encode( unsigned char* output, Q_UINT32 *in, Q_UINT32 len );
  void decode( Q_UINT32 *output, const unsigned char* in, Q_UINT32 len );

  Q_UINT32 rotate_left( Q_UINT32 x, Q_UINT32 n );
  Q_UINT32 F( Q_UINT32 x, Q_UINT32 y, Q_UINT32 z );
  Q_UINT32 G( Q_UINT32 x, Q_UINT32 y, Q_UINT32 z );
  Q_UINT32 H( Q_UINT32 x, Q_UINT32 y, Q_UINT32 z );
  Q_UINT32 I( Q_UINT32 x, Q_UINT32 y, Q_UINT32 z );
  void FF( Q_UINT32& a, Q_UINT32 b, Q_UINT32 c, Q_UINT32 d, Q_UINT32 x,
               Q_UINT32  s, Q_UINT32 ac );
  void GG( Q_UINT32& a, Q_UINT32 b, Q_UINT32 c, Q_UINT32 d, Q_UINT32 x,
                Q_UINT32 s, Q_UINT32 ac );
  void HH( Q_UINT32& a, Q_UINT32 b, Q_UINT32 c, Q_UINT32 d, Q_UINT32 x,
                Q_UINT32 s, Q_UINT32 ac );
  void II( Q_UINT32& a, Q_UINT32 b, Q_UINT32 c, Q_UINT32 d, Q_UINT32 x,
             Q_UINT32 s, Q_UINT32 ac );

private:
  Q_UINT32 m_state[4];
  Q_UINT32 m_count[2];
  Q_UINT8 m_buffer[64];
  Digest m_digest;
  bool m_finalized;

//  KstMD5Private* d;
};

#endif
