/* Copyright (C) 2002 Philippe Fremy <pfremy@kde.org>
   Strongly inspired by other KPart applications and tutorials.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "vimpart_factory.h"

#include <klocale.h>
#include <kstddirs.h>
#include <kinstance.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <assert.h>

#include "vimpart.h"

extern "C"
{
    void* init_libvimpart()
    {
	return new VimPartFactory;
    }
};

KInstance* VimPartFactory::s_instance = 0L;
KAboutData* VimPartFactory::s_about = 0L;

VimPartFactory::VimPartFactory()
  : KLibFactory()
{
}

VimPartFactory::~VimPartFactory()
{
  delete s_instance;
  delete s_about;

  s_instance = 0L;
}

QObject* VimPartFactory::createObject( QObject* parent, const char* name, const char* classname, const QStringList & )
{
  if ( parent && !parent->inherits("QWidget") )
  {
    kdDebug() << "VimPartFactory: parent does not inherit QWidget" << endl;
    return 0L;
  }

  VimPart* obj = new VimPart( (QWidget*) parent, name );
  // readwrite ?

  //kdDebug() << "VimPartFactory::create() - className : " << classname;
  if (QString(classname) == "KParts::ReadWritePart") {
      obj->setReadWrite(true);
	  //kdDebug() << "Setting read/write mode" << endl;
  } else {
      // otherwise, it has to be readonly
      obj->setReadWrite(false);
	  //kdDebug() << "Setting readonly mode" << endl;
  }

  return obj;
}

KInstance* VimPartFactory::instance()
{
  if( !s_instance )
  {
    s_about = new KAboutData( "VimPart", I18N_NOOP( "VimPart" ), "0.1" );
    s_instance = new KInstance( s_about );
  }
  return s_instance;
}
