# - Try to find Policykit
# Once done this will define
#
#  POLICYKIT_FOUND - system has Policykit
#  POLICYKIT_INCLUDE_DIRS - Policykit's include directories
#  POLICYKIT_LIBRARIES - Link this to use Policykit's libraries
#  POLICYKIT_AGENT_LIBRARY - Link this to use the agent wrapper in polkit
#  POLICYKIT_DEFINITIONS - Compiler switches required for using Policykit

# Copyright (c) 2009, Dario Freddi, <drf@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

if (POLICYKIT_INCLUDE_DIR AND POLICYKIT_LIB)
    set(POLICYKIT_FIND_QUIETLY TRUE)
endif (POLICYKIT_INCLUDE_DIR AND POLICYKIT_LIB)

if (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   find_package(PkgConfig)
   pkg_check_modules (PC_POLICYKIT polkit>=0.8)
   pkg_check_modules (PC_POLICYKITDBUS polkit-dbus>=0.8)
   pkg_check_modules (PC_POLICYKITGRANT polkit-grant>=0.8)
   set(POLICYKIT_DEFINITIONS ${PC_POLICYKIT_CFLAGS_OTHER})
endif (NOT WIN32)

# We must include glib paths too... which sucks balls
find_package(GLIB2)
# And DBus as well!
find_package(DBus)

find_path( _POLICYKIT_INCLUDE_DIR
     NAMES polkit/polkit.h
     PATH_SUFFIXES PolicyKit
     HINTS ${PC_POLICYKIT_INCLUDE_DIRS}
)

set(POLICYKIT_INCLUDE_DIRS ${GLIB2_INCLUDE_DIR} ${_POLICYKIT_INCLUDE_DIR} ${DBUS_INCLUDE_DIR} ${DBUS_ARCH_INCLUDE_DIR})

find_library( _POLICYKIT_LIBRARY
    NAMES polkit
    HINTS ${PC_POLICYKIT_LIBDIR}
)

find_library( _POLICYKIT_GRANT_LIBRARY
    NAMES polkit-grant
    HINTS ${PC_POLICYKITGRANT_LIBDIR}
)

find_library( _POLICYKIT_DBUS_LIBRARY
    NAMES polkit-dbus
    HINTS ${PC_POLICYKITDBUS_LIBDIR}
)

set(POLICYKIT_LIBRARIES ${_POLICYKIT_DBUS_LIBRARY} ${_POLICYKIT_GRANT_LIBRARY} ${_POLICYKIT_LIBRARY})

include(FindPackageHandleStandardArgs)

# handle the QUIETLY and REQUIRED arguments and set POLICYKIT_FOUND to TRUE if
# all listed variables are TRUE
find_package_handle_standard_args(Policykit DEFAULT_MSG _POLICYKIT_LIBRARY _POLICYKIT_GRANT_LIBRARY _POLICYKIT_DBUS_LIBRARY
                                                        _POLICYKIT_INCLUDE_DIR GLIB2_FOUND DBUS_FOUND)

mark_as_advanced(POLICYKIT_INCLUDE_DIRS POLICYKIT_AGENT_INCLUDE_DIRS POLICYKIT_LIBRARY POLICYKIT_AGENT_LIBRARY GLIB_INCLUDE_DIR POLICYKIT_LIBRARIES)

set(POLICYKIT_POLICY_FILES_INSTALL_DIR ${CMAKE_INSTALL_PREFIX}/share/PolicyKit/policy)
