#!/usr/bin/env python

import sys, os, re

functions = """
MDETERM
MINVERSE
MMULT
MUNIT
SUMPRODUCT
SUMX2MY2
SUMX2PY2
SUMXMY2
TRANSPOSE
BITAND
BITLSHIFT
BITOR
BITRSHIFT
BITXOR
FINDB
LEFTB
LENB
MIDB
REPLACEB
RIGHTB
SEARCHB
COMPLEX
IMABS
IMAGINARY
IMARGUMENT
IMCONJUGATE
IMCOS
IMCOT
IMCSC
IMCSCH
IMDIV
IMEXP
IMLN
IMLOG10
IMLOG2
IMPOWER
IMPRODUCT
IMREAL
IMSIN
IMSEC
IMSECH
IMSQRT
IMSUB
IMSUM
IMTAN
DAVERAGE
DCOUNT
DCOUNTA
DGET
DMAX
DMIN
DPRODUCT
DSTDEV
DSTDEVP
DSUM
DVAR
DVARP
DATE
DATEDIF
DATEVALUE
DAY
DAYS
DAYS360
EDATE
EOMONTH
HOUR
ISOWEEKNUM
MINUTE
MONTH
NETWORKDAYS
NOW
SECOND
TIME
TIMEVALUE
TODAY
WEEKDAY
WEEKNUM
WORKDAY
YEAR
YEARFRAC
External
DDE
HYPERLINK
ACCRINT
ACCRINTM
AMORDEGRC
AMORLINC
COUPDAYBS
COUPDAYS
COUPDAYSNC
COUPNCD
COUPNUM
COUPPCD
CUMIPMT
CUMPRINC
DB
DDB
DISC
DOLLARDE
DOLLARFR
DURATION
EFFECT
FV
FVSCHEDULE
INTRATE
IPMT
IRR
ISPMT
MDURATION
MIRR
NOMINAL
NPER
NPV
ODDFPRICE
ODDFYIELD
ODDLPRICE
ODDLYIELD
PDURATION
PMT
PPMT
PRICE
PRICEDISC
PRICEMAT
PV
RATE
RECEIVED
RRI
SLN
SYD
TBILLEQ
TBILLPRICE
TBILLYIELD
VDB
XIRR
XNPV
YIELD
YIELDDISC
YIELDMAT
AREAS
CELL
COLUMN
COLUMNS
COUNT
COUNTA
COUNTBLANK
COUNTIF
COUNTIFS
ERROR.TYPE
FORMULA
INFO
ISBLANK
ISERR
ISERROR
ISEVEN
ISFORMULA
ISLOGICAL
ISNA
ISNONTEXT
ISNUMBER
ISODD
ISREF
ISTEXT
N
NA
NUMBERVALUE
ROW
ROWS
SHEET
SHEETS
TYPE
VALUE
ADDRESS
CHOOSE
GETPIVOTDATA
HLOOKUP
INDEX
INDIRECT
LOOKUP
MATCH
MULTIPLE.OPERATIONS
OFFSET
VLOOKUP
AND
FALSE
IF
IFERROR
IFNA
NOT
OR
TRUE
XOR
ABS
ACOS
ACOSH
ACOT
ACOTH
ASIN
ASINH
ATAN
ATAN2
ATANH
BESSELI
BESSELJ
BESSELK
BESSELY
COMBIN
COMBINA
CONVERT
COS
COSH
COT
COTH
CSC
CSCH
DEGREES
DELTA
ERF
ERFC
EUROCONVERT
EVEN
EXP
FACT
FACTDOUBLE
GAMMA
GAMMALN
GCD
GESTEP
LCM
LN
LOG
LOG10
MOD
MULTINOMIAL
ODD
PI
POWER
PRODUCT
QUOTIENT
RADIANS
RAND
RANDBETWEEN
SEC
SERIESSUM
SIGN
SIN
SINH
SECH
SQRT
SQRTPI
SUBTOTAL
SUM
SUMIF
SUMIFS
SUMSQ
TAN
TANH
CEILING
INT
FLOOR
MROUND
ROUND
ROUNDDOWN
ROUNDUP
TRUNC
AVEDEV
AVERAGE
AVERAGEA
AVERAGEIF
AVERAGEIFS
B
BETADIST
BETAINV
BINOMDIST
LEGACY.CHIDIST
CHISQDIST
LEGACY.CHIINV
CHISQINV
LEGACY.CHITEST
CONFIDENCE
CORREL
COVAR
CRITBINOM
DEVSQ
EXPONDIST
FDIST
LEGACY.FDIST
FINV
LEGACY.FINV
FISHER
FISHERINV
FORECAST
FREQUENCY
FTEST
GAMMADIST
GAMMAINV
GAUSS
GEOMEAN
GROWTH
HARMEAN
HYPGEOMDIST
INTERCEPT
KURT
LARGE
LINEST
LOGEST
LOGINV
LOGNORMDIST
MAX
MAXA
MEDIAN
MIN
MINA
MODE
NEGBINOMDIST
NORMDIST
NORMINV
LEGACY.NORMSDIST
LEGACY.NORMSINV
PEARSON
PERCENTILE
PERCENTRANK
PERMUT
PERMUTATIONA
PHI
POISSON
PROB
QUARTILE
RANK
RSQ
SKEW
SKEWP
SLOPE
SMALL
STANDARDIZE
STDEV
STDEVA
STDEVP
STDEVPA
STEYX
TDIST
TINV
TREND
TRIMMEAN
TTEST
VAR
VARA
VARP
VARPA
WEIBULL
ZTEST
ARABIC
BASE
BIN2DEC
BIN2HEX
BIN2OCT
DEC2BIN
DEC2HEX
DEC2OCT
DECIMAL
HEX2BIN
HEX2DEC
HEX2OCT
OCT2BIN
OCT2DEC
OCT2HEX
ROMAN
ASC
CHAR
CLEAN
CODE
CONCATENATE
DOLLAR
EXACT
FIND
FIXED
JIS
LEFT
LEN
LOWER
MID
PROPER
REPLACE
REPT
RIGHT
SEARCH
SUBSTITUTE
T
TEXT
TRIM
"""

def functionName(name):
    #return name.strip().lower()
    return name.strip().replace('.','').replace('_','').lower()

functions1 = [ functionName(line) for line in [ k for k in [ i.strip() for i in functions.split("\n") ] if len(k)>0 ] ]

functions2 = []
path = os.path.join(os.path.split(sys.argv[0])[0],"../functions")
for n in [ f for f in os.listdir(path) if f.endswith(".cpp") ]:
    f = open(os.path.join(path,n), 'r')
    for t in [t.strip() for t in f.read().split("\n") ]:
        m = re.search('(?!//|/\*).*new\s+Function\s*\(\s*\"(.+)\"', t)
        if m:
            functions2.append( functionName(m.group(1)) )
        else:
            m = re.search('(?!//|/\*).*\-\>\s*setAlternateName\s*\(\s*\"(.+)\"', t)
            if m:
                functions2.append( functionName(m.group(1)) )

diff = list(set(functions1).difference(set(functions2)))
diff.sort()
print "%s missing OpenFormula functions (%s available):\n%s" % (len(diff), len(functions2), " ".join(diff))
