/***************************************************************************
                          setup.cpp  -  description
                             -------------------
    begin                : Fri Dec 21 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>

#include <qlistview.h>
#include <qradiobutton.h>
#include <qbutton.h>
#include <qbuttongroup.h>


#include "setup.h"

Setup::Setup(QWidget *parent, const char *name ): Setup_Dialog(parent, name, true){
  
  getCameraListings();

  QButtonGroup_portName->setExclusive(true);

  loadCameraSettings();
  
}

Setup::~Setup(){
  delete config;
}

void Setup::getCameraListings() {

  int numSupportedCameras = gp_camera_count();
  if (numSupportedCameras < 0) {
    qWarning("failed to get list of cameras");
    return;
  }
  else {
    for (int i=0; i<numSupportedCameras; i++) {
      const char *cameraName;
      if (gp_camera_name(i,&cameraName) == GP_OK) {
	new QListViewItem(QListView_cameras, cameraName);
      }
    }
  }
}

void Setup::loadCameraSettings() {

  config = new KSimpleConfig("digikamrc");
  config->setGroup("Camera Settings");
  if (config->readEntry("Camera Model") != NULL) {
    my_cameraName=config->readEntry("Camera Model");
    my_cameraPortName=config->readEntry("Camera Port Name");
    my_cameraPortPath=config->readEntry("Camera Port Path");

    QListViewItem *item = QListView_cameras->firstChild();
    do {
      if (item->text(0) == my_cameraName) {
	QListView_cameras->setSelected(item, true);
	QListView_cameras->ensureItemVisible(item);
	break;
      }
    } while ( item = item->nextSibling());
    
  }

}


void Setup::saveCameraSettings() {

  if (QListView_cameras->selectedItem()) {

    my_cameraName=QListView_cameras->selectedItem()->text(0);
    
    QString type = QButtonGroup_portName->selected()->text();
    
    if (type == i18n("Serial"))
      my_cameraPortName="serial:";
    else if(type == i18n("Parallel"))
      my_cameraPortName="parallel:";
    else if(type == i18n("USB"))
      my_cameraPortName="usb:";
    else if(type == i18n("FireWire"))
      my_cameraPortName="ieee1394:";
    
    config->setGroup("Camera Settings");
    config->writeEntry("Camera Model",my_cameraName);
    config->writeEntry("Camera Port Name",my_cameraPortName);
    config->writeEntry("Camera Port Path",my_cameraPortPath);
    config->sync();
  }
}

void Setup::slot_cancel() {
  close();
}

void Setup::slot_ok() {
  saveCameraSettings();
  close();
}

void Setup::slot_apply() {
  saveCameraSettings();
}

void Setup::slot_autoDetect() {

  const char *cameraName, *cameraPortName;
  CameraList *cameraList;

  gp_list_new (&cameraList);
  if (gp_autodetect(cameraList)!=GP_OK) {
    KMessageBox::error(this,"Failed to auto-detect camera!\n"\
		       "Please rety or try setting manually.");
    return;
  }

  float count = gp_list_count (cameraList);

  if (count==0) {
    KMessageBox::error(this,"Failed to auto-detect camera!\n"\
		       "Please rety or try setting manually.");
    return;
  }


  for (int i = 0; i < count; i++) {
    gp_list_get_name  (cameraList, i, &cameraName);
    gp_list_get_value (cameraList, i, &cameraPortName);
  }
  
  qWarning(cameraName);
  qWarning(cameraPortName);
  
  QListViewItem *item = QListView_cameras->firstChild();
  do {
    if (item->text(0) == cameraName) {
      QListView_cameras->setSelected(item, true);
      QListView_cameras->ensureItemVisible(item);
      break;
    }
  } while ( item = item->nextSibling());

  if (cameraPortName=="parallel:") 
    slot_setPortName(QButtonGroup_portName->id(QRadioButton_parallel));
  else if (cameraPortName=="serial:")
    slot_setPortName(QButtonGroup_portName->id(QRadioButton_serial));
  else if (cameraPortName=="usb:")
    slot_setPortName(QButtonGroup_portName->id(QRadioButton_usb));
  else if (cameraPortName=="ieee1394:")
    slot_setPortName(QButtonGroup_portName->id(QRadioButton_firewire));

  QString infoStr;
  infoStr = infoStr+"Detected a " +  cameraName;
  KMessageBox::information(this,infoStr);

    
  gp_list_free (cameraList);

}


void Setup::slot_setModel(QListViewItem *item) {

  QString cameraName = item->text(0);
  CameraAbilities abilities;

  gp_camera_abilities_by_name(cameraName, &abilities);
  QRadioButton_serial->setEnabled(SERIAL_SUPPORTED(abilities.port));
  QRadioButton_parallel->setEnabled(PARALLEL_SUPPORTED(abilities.port));
  QRadioButton_usb->setEnabled(USB_SUPPORTED(abilities.port));
  QRadioButton_firewire->setEnabled(IEEE1394_SUPPORTED(abilities.port));

  QButton *selected = QButtonGroup_portName->selected();
  if(selected != NULL)
    selected->toggle();
  
 
  if ((SERIAL_SUPPORTED(abilities.port)?1:0) + (PARALLEL_SUPPORTED(abilities.port)?1:0) + 
      (USB_SUPPORTED(abilities.port)?1:0) + (IEEE1394_SUPPORTED(abilities.port)?1:0)) {
    if (SERIAL_SUPPORTED(abilities.port)) slot_setPortName(QButtonGroup_portName->id(QRadioButton_serial));
    if (PARALLEL_SUPPORTED(abilities.port)) slot_setPortName(QButtonGroup_portName->id(QRadioButton_parallel));
    if (USB_SUPPORTED(abilities.port)) slot_setPortName(QButtonGroup_portName->id(QRadioButton_usb));
    if (IEEE1394_SUPPORTED(abilities.port)) slot_setPortName(QButtonGroup_portName->id(QRadioButton_firewire));
  };


}

  
void Setup::slot_setPortName(int portType) {
  
   QButtonGroup_portName->setButton(portType);
   

}
