/***************************************************************************
                          setup.cpp  -  description
                             -------------------
    begin                : Fri Dec 21 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>

#include <qlistview.h>
#include <qradiobutton.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qcombobox.h>

#include "setup.h"

Setup::Setup(QWidget *parent, const char *name ): Setup_Dialog(parent, name, true){
  
  getCameraListings();

  QButtonGroup_port->setExclusive(true);

  loadCameraSettings();
  
}

Setup::~Setup(){

}

void Setup::getCameraListings() {

  CameraAbilitiesList *abilList;
  CameraAbilities abil;

  gp_abilities_list_new (&abilList);
  gp_abilities_list_load (abilList);
  
  int numSupportedCameras = gp_abilities_list_count (abilList);
  if (numSupportedCameras < 0) {
    qWarning("failed to get list of cameras");
    return;
  }
  else {
    for (int i=0; i<numSupportedCameras; i++) {
      const char *cameraName;
      gp_abilities_list_get_abilities (abilList, i, &abil);
      cameraName=abil.model;
      new QListViewItem(QListView_cameras, cameraName);
    }
  }

  gp_abilities_list_free (abilList);

}


void Setup::loadCameraSettings() {

  char model[64], port[128];
  QString portPath;

  gp_setting_get ("digikam", "model", model);
  gp_setting_get ("digikam", "port", port);

  my_cameraModel = model;
  my_cameraPort = port;

  if (my_cameraModel != "" && my_cameraPort != "") {
    
    QListViewItem *item = QListView_cameras->firstChild();
    do {
      if (item->text(0) == my_cameraModel) {
	QListView_cameras->setSelected(item, true);
	QListView_cameras->ensureItemVisible(item);
	break;
      }
    } while ( item = item->nextSibling());

    if (my_cameraPort.startsWith("serial:")) {
      slot_setPort(QButtonGroup_port->id(QRadioButton_serial));
      portPath=my_cameraPort;
      portPath.remove(0,7);
      QComboBox_portPath->insertItem(portPath,0);
    }
    else if (my_cameraPort.startsWith("usb:")) 
      slot_setPort(QButtonGroup_port->id(QRadioButton_usb));
    
  }

}



void Setup::saveCameraSettings() {

  QString portPath;

  if (QListView_cameras->selectedItem()) {

    my_cameraModel=QListView_cameras->selectedItem()->text(0);
    
    QString type = QButtonGroup_port->selected()->text();
    
    if (type == i18n("Serial")) { 
      my_cameraPort="serial:";
      portPath=QComboBox_portPath->currentText();
      if (!portPath.isEmpty())
	my_cameraPort=my_cameraPort+portPath;
    }
    else if(type == i18n("Parallel"))
      my_cameraPort="parallel:";
    else if(type == i18n("USB"))
      my_cameraPort="usb:";
    else if(type == i18n("FireWire"))
      my_cameraPort="ieee1394:";
    
    gp_setting_set ("digikam", "model", my_cameraModel.local8Bit().data());
    gp_setting_set ("digikam", "port", my_cameraPort.local8Bit().data());

    
  }
}

void Setup::slot_cancel() {
  close();
}

void Setup::slot_ok() {
  saveCameraSettings();
  close();
}

void Setup::slot_apply() {
  saveCameraSettings();
}


void Setup::slot_autoDetect() {

  CameraList camList;
  CameraAbilitiesList *abilList;
  GPPortInfoList *infoList;
  const char *cameraModel, *cameraPort;
  QString portPath;

  gp_abilities_list_new (&abilList);
  gp_abilities_list_load (abilList);
  gp_port_info_list_new (&infoList);
  gp_port_info_list_load (infoList);
  gp_abilities_list_detect (abilList, infoList, &camList);
  gp_abilities_list_free (abilList);
  gp_port_info_list_free (infoList);

  int count = gp_list_count (&camList);

  if (count<=0) {
    KMessageBox::error(this,"Failed to auto-detect camera!\n"\
		       "Please rety or try setting manually.");
    return;
  }

  for (int i = 0; i < count; i++) {
    gp_list_get_name  (&camList, i, &cameraModel);
    gp_list_get_value (&camList, i, &cameraPort);
  }
  
  qWarning(cameraModel);
  qWarning(cameraPort);
  
  QListViewItem *item = QListView_cameras->firstChild();
  do {
    if (item->text(0) == cameraModel) {
      QListView_cameras->setSelected(item, true);
      QListView_cameras->ensureItemVisible(item);
      break;
    }
  } while ( item = item->nextSibling());


  portPath=QString(cameraPort);
  
  if (QString(cameraPort).startsWith("parallel:")) {
    slot_setPort(QButtonGroup_port->id(QRadioButton_parallel));
    portPath.remove(0,9);
    QComboBox_portPath->insertItem(portPath,0);
  }
  else if (QString(cameraPort).startsWith("serial:")) {
    slot_setPort(QButtonGroup_port->id(QRadioButton_serial));
    portPath.remove(0,7);
    QComboBox_portPath->insertItem(portPath,0);
  }
  else if (QString(cameraPort).startsWith("usb:")) 
    slot_setPort(QButtonGroup_port->id(QRadioButton_usb));
  else if (QString(cameraPort).startsWith("ieee1394:")) 
    slot_setPort(QButtonGroup_port->id(QRadioButton_firewire));

  QString infoStr;
  infoStr = infoStr+"Detected a " +  cameraModel + " with port " + cameraPort;
  KMessageBox::information(this,infoStr);
  
    
}


void Setup::slot_setModel(QListViewItem *item) {

  int x = 0;
  QString cameraModel = item->text(0);
  CameraAbilities abilities;
  CameraAbilitiesList *abilList;
  
  gp_abilities_list_new (&abilList);
  gp_abilities_list_load (abilList);
  x = gp_abilities_list_lookup_model (abilList, cameraModel.local8Bit().data());
  gp_abilities_list_get_abilities (abilList, x, &abilities);
  gp_abilities_list_free (abilList);


  QRadioButton_serial->setEnabled(abilities.port & GP_PORT_SERIAL);
  QRadioButton_usb->setEnabled(abilities.port & GP_PORT_USB);
  QRadioButton_parallel->setEnabled(false);
  QRadioButton_firewire->setEnabled(false);
  
  QButton *selected = QButtonGroup_port->selected();
  if(selected != NULL)
    selected->toggle();

  if ((GP_PORT_SERIAL?1:0) + (GP_PORT_USB?1:0)) {
    if (abilities.port & GP_PORT_SERIAL) slot_setPort(QButtonGroup_port->id(QRadioButton_serial));
    if (abilities.port & GP_PORT_USB) slot_setPort(QButtonGroup_port->id(QRadioButton_usb));
  }
 
  
}


  
void Setup::slot_setPort(int portType) {
  
   QButtonGroup_port->setButton(portType);
   
   slot_setPortPathLabel(portType);

}

void Setup::slot_setPortPathLabel(int portType) {

  if (portType==QButtonGroup_port->id(QRadioButton_serial)) {
     QTextLabel_portPath->setText("Set Port Path for \n"
				  "serial port");
     QComboBox_portPath->setEditable(true);
  }

  if (portType==QButtonGroup_port->id(QRadioButton_parallel)) {
     QTextLabel_portPath->setText("Set Port Path for \n"
				  "parallel port");
     QComboBox_portPath->setEditable(true);
  }


  if (portType==QButtonGroup_port->id(QRadioButton_usb)) {
    QTextLabel_portPath->setText("No further configuration\n"
				 "needed for usb");
    QComboBox_portPath->clear();
    QComboBox_portPath->setEditable(false);
  }
 
}


