/***************************************************************************
                          camera_iconview.cpp  -  description
                             -------------------
    begin                : Sat Jan 5 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qstring.h>
#include <qpixmap.h>

#include "camera_iconview.h"

Camera_IconView::Camera_IconView(QWidget* parent): 
  KIconView(parent) {

  setMode(KIconView::Select);
  setGridX(95);
  setGridY(95);
  setAutoArrange(true);
  setSorting(true);
  setResizeMode(QIconView::Adjust);
  setWordWrapIconText(true);
  setSelectionMode(QIconView::Extended);
  setItemsMovable(false);

}

Camera_IconView::~Camera_IconView(){
}

Camera_IconViewItem::Camera_IconViewItem(Camera_IconView* parent):
  QIconViewItem(parent) {
  
  setDropEnabled(false);
  setDragEnabled(false);

  thumbNailed = false;
  mimeType = "";
  cameraFolder = "";
  thumbNail = NULL;
  itemInGlobal = NULL;
}

Camera_IconViewItem::~Camera_IconViewItem() {
  if (thumbNailed && (cameraFolder != "Global"))
    delete thumbNail;
}

bool Camera_IconViewItem::isThumbNailed() { 
  return thumbNailed;
}

void Camera_IconViewItem::setThumbNail(QPixmap* icon) { 

  if (!icon) return; 
  thumbNailed=true; 
  //thumbNail= new QPixmap;
  thumbNail=icon; 
  setPixmap(*thumbNail);

}

void Camera_IconViewItem::setThumbNail() { 
  setPixmap(*thumbNail); 
}

void Camera_IconViewItem::setMimeType(const QString& mime) { 
  mimeType=mime; 
}

QString Camera_IconViewItem::getMimeType() { 
  return mimeType; 
}
  
void Camera_IconViewItem::setCameraFolder(const QString& folder) {
  cameraFolder = folder;
}

QString Camera_IconViewItem::getCameraFolder() {
  return cameraFolder;
}


void Camera_IconViewItem::setPixmapForMime() {

  if (mimeType.contains("image"))
    setPixmap(BarIcon("image", KIcon::SizeLarge));
  else if ( mimeType.contains("audio") )
    setPixmap(BarIcon("sound", KIcon::SizeLarge));
  else if ( mimeType.contains("video") )
    setPixmap(BarIcon("video", KIcon::SizeLarge));

}
