/***************************************************************************
                          digikam_view.cpp  -  description
                             -------------------
    begin                : Wed Jan 9 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klocale.h>
#include <kiconview.h>
#include <klistview.h>
#include <kstatusbar.h>
#include <kprogress.h>
#include <kcombobox.h>

#include <qtabwidget.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qwidgetstack.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qdir.h>
#include <qprogressbar.h>

#include "digikam_view.h"
#include "gphoto_messages.h"
#include "photo_foldertree.h"
#include "photo_iconview.h"

Digikam_View::Digikam_View(QWidget *parent = 0, const char *name=0) 
  : QWidget(parent, name) 
{

  MainLayout = new QGridLayout( this );
  MainLayout->setSpacing( 6 );
  MainLayout->setMargin( 11 );

  TabWidget = new QTabWidget( this, "TabWidget" );
  TabWidget->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7,
					 TabWidget->sizePolicy().hasHeightForWidth() ) );
  TabWidget->setTabPosition( QTabWidget::Top );
  TabWidget->setTabShape( QTabWidget::Rounded );

  tabCameraBrowser = new QWidget( TabWidget, "tabCameraBrowser" );
  tabCameraBrowser_Layout = new QGridLayout( tabCameraBrowser );
  tabCameraBrowser_Layout->setSpacing( 6 );
  tabCameraBrowser_Layout->setMargin( 11 );

  QCheckBox_thumbNails = new QCheckBox( "ThumbNails", tabCameraBrowser);
  tabCameraBrowser_Layout->addWidget( QCheckBox_thumbNails, 0, 0 );  

  cameraLabel = new QLabel(tabCameraBrowser);
  tabCameraBrowser_Layout->addWidget(cameraLabel, 0, 1);

  KListView_camFolders = new KListView( tabCameraBrowser, "KListView_camFolders" );
  KListView_camFolders->addColumn( tr( "Camera Folders" ) );
  KListView_camFolders->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)7) );
  KListView_camFolders->setMinimumSize( QSize( 200, 0 ) );
  KListView_camFolders->setFullWidth();
  tabCameraBrowser_Layout->addWidget( KListView_camFolders, 1, 0 );

  QWidgetStack_camIconViews = new QWidgetStack(tabCameraBrowser);
  QWidgetStack_camIconViews->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7,
                                                   (QSizePolicy::SizeType)7));

  KIconView_camIconViewRoot = new KIconView( QWidgetStack_camIconViews, "KIconView_camIconViewRoot" );
  KIconView_camIconViewRoot->setResizeMode( KIconView::Adjust );
  KIconView_camIconViewRoot->setItemsMovable( FALSE );

  QWidgetStack_id = 0;
  QWidgetStack_camIconViews->addWidget(KIconView_camIconViewRoot, QWidgetStack_id);
  QWidgetStack_camIconViews->raiseWidget(QWidgetStack_id);

  tabCameraBrowser_Layout->addWidget( QWidgetStack_camIconViews, 1, 1 );


  QGroupBox_camBottom = new QGroupBox( tabCameraBrowser, "QGroupBox_camBottom" );
  QGroupBox_camBottom->setFrameShape( QGroupBox::NoFrame );
  QGroupBox_camBottom->setTitle( QString::null );
  QGroupBox_camBottom->setColumnLayout(0, Qt::Vertical );
  QGroupBox_camBottom->layout()->setSpacing( 0 );
  QGroupBox_camBottom->layout()->setMargin( 0 );
  QGroupBox_camBottomLayout = new QGridLayout( QGroupBox_camBottom->layout() );
  QGroupBox_camBottomLayout->setAlignment( Qt::AlignTop );
  QGroupBox_camBottomLayout->setSpacing( 6 );
  QGroupBox_camBottomLayout->setMargin( 11 );

  QLabel* camDirBoxLabel = new QLabel("Download Directory : ", QGroupBox_camBottom);
  QGroupBox_camBottomLayout->addWidget( camDirBoxLabel, 0, 0);

  camDirBox = new KComboBox( true, QGroupBox_camBottom, "camDirBox" );
  camDirBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0 ) );
  camDirBox->setDuplicatesEnabled( false );
  camDirBox->insertItem(QDir::currentDirPath());
  camDirBox->insertItem(QDir::homeDirPath());  
  QGroupBox_camBottomLayout->addWidget( camDirBox, 0, 1);

  QPushButton_camBrowse = new QPushButton( QGroupBox_camBottom, "QPushButton_browse" );
  QPushButton_camBrowse->setText( i18n( "Browse" ) );
  QGroupBox_camBottomLayout->addWidget( QPushButton_camBrowse, 0, 2);

  tabCameraBrowser_Layout->addMultiCellWidget( QGroupBox_camBottom, 2, 2, 0, 1);



  camStatusBar = new KStatusBar(tabCameraBrowser);
  camStatusBar->insertItem ("Ready", 0, 7, false);
  camStatusBar->setItemAlignment (0, AlignLeft | AlignVCenter);
  QLabel *spacer=new  QLabel(camStatusBar);
  camStatusBar->addWidget(spacer, 1, true);  

  camProgressBar=new KProgress(0,100,0,KProgress::Horizontal,camStatusBar);
  camProgressBar->setBarStyle(KProgress::Blocked);
  camProgressBar->setTextEnabled(false);
  camStatusBar->addWidget( camProgressBar, 5, true);

  tabCameraBrowser_Layout->addMultiCellWidget(camStatusBar, 3, 3, 0, 1);

  


  TabWidget->insertTab( tabCameraBrowser, tr( "Camera Browser" ) );




  tabPhotoBrowser = new QWidget( TabWidget, "tabPhotoBrowser" );
  tabPhotoBrowser_Layout = new QGridLayout( tabPhotoBrowser );
  tabPhotoBrowser_Layout->setSpacing( 6 );
  tabPhotoBrowser_Layout->setMargin( 11 );

  photoFolderTree = new Photo_FolderTree(tabPhotoBrowser);
  photoFolderTree->addColumn( tr( "Folders" ) );
  photoFolderTree->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)7 ) );
  photoFolderTree->setMinimumSize( QSize( 200, 0 ) );
  photoFolderTree->setFullWidth();
  tabPhotoBrowser_Layout->addWidget( photoFolderTree, 0, 0 );

  photoIconView = new Photo_IconView( tabPhotoBrowser);
  tabPhotoBrowser_Layout->addWidget( photoIconView, 0, 1 );

  photoStatusBar = new KStatusBar(tabPhotoBrowser);
  photoStatusBar->insertItem ("Ready", 0, 7, false);
  photoStatusBar->setItemAlignment (0, AlignLeft | AlignVCenter);
  QLabel *spacer2=new  QLabel(photoStatusBar);
  photoStatusBar->addWidget(spacer2, 1, true);  

  photoProgressBar=new  QProgressBar(photoStatusBar);
  photoStatusBar->addWidget( photoProgressBar, 5, true);

  tabPhotoBrowser_Layout->addMultiCellWidget(photoStatusBar, 1, 1, 0, 1);


  TabWidget->insertTab( tabPhotoBrowser, tr( "Photo Browser" ) );


  MainLayout->addWidget( TabWidget, 0, 0 );




  connect(TabWidget, SIGNAL(currentChanged(QWidget *)), parent, SLOT(slot_showHideToolBars(QWidget*)) );
  connect(KListView_camFolders, SIGNAL(executed(QListViewItem *)),
          parent, SLOT(slot_camFolderViewClicked(QListViewItem *)));
  connect( QCheckBox_thumbNails, SIGNAL( toggled(bool) ), parent, SLOT( slot_getThumbNails(bool) ) );

  connect(Gphoto_Messages::gpMessagesWrapper(), SIGNAL(statusChanged(const QString&)),
	  parent, SLOT(slot_setCamStatusMsg(const QString&)));
  connect(Gphoto_Messages::gpMessagesWrapper(), SIGNAL(progressChanged(int)),
	  parent, SLOT(slot_setCamProgressBarValue(int)) );
	  //SLOT(setValue(int)));

  connect(QPushButton_camBrowse, SIGNAL( clicked() ), parent, SLOT( slot_camDirBrowse() ) );


  connect(photoFolderTree, SIGNAL(executed(QListViewItem *)),
          parent, SLOT(slot_photoFolderClicked(QListViewItem *)));
  connect(photoIconView, SIGNAL(startedGenThumbnail(int)),
	  this, SLOT(slot_startedGenThumbnail(int)) );
  connect(photoIconView, SIGNAL(stoppedGenThumbnail()),
	  this, SLOT(slot_stoppedGenThumbnail()) );
  connect(photoIconView, SIGNAL(generatedOneThumbnail()),
	  this, SLOT(slot_generatedOneThumbnail()) );
  
  connect(photoIconView, SIGNAL(startedGenThumbnail(int)),
	  parent, SLOT(slot_startedGenThumbNails()) );
  connect(photoIconView, SIGNAL(stoppedGenThumbnail()),
	  parent, SLOT(slot_stoppedGenThumbNails()) );

}


Digikam_View::~Digikam_View(){
}


void Digikam_View::slot_setCamStatusMsg(const QString &msg) {

  //camStatusBar->message(msg,2000);
  camStatusBar->changeItem(msg,0);

}

void Digikam_View::slot_startedGenThumbnail(int count) {

	if (! photoFolderTree->selectedItem() ) {
		return;
  }
			
  QString msg = "Generating Thumbnails ... (" + photoFolderTree->selectedItem()->text(0) + ")"; 
  photoStatusBar->changeItem(msg, 0);
  
  photoProgressBar->setTotalSteps(count);

}

void Digikam_View::slot_stoppedGenThumbnail() {

	if (! photoFolderTree->selectedItem() ) {
		photoProgressBar->reset();	
		return;
	}
  photoIconView->arrangeItemsInGrid();

  QString imgCount;
  imgCount.setNum( ((QIconView*)photoIconView)->count() );
  QString msg = photoFolderTree->selectedItem()->text(0) 
    + " (" +  imgCount + " Images)";
  photoStatusBar->changeItem(msg, 0);
  photoProgressBar->reset();
}

void Digikam_View::slot_generatedOneThumbnail() {
  photoProgressBar->setProgress(photoProgressBar->progress()+1);
}
