#ifndef EXIF_PARSER_H
#define EXIF_PARSER_H

#include <fstream>
#include <vector>
#include <string>

//-- Jpeg Image Maker Types --------------------------------------------

#define M_SOF0  0xC0            // Start Of Frame N
#define M_SOF1  0xC1            // N indicates which compression process
#define M_SOF2  0xC2            // Only SOF0-SOF2 are now in common use
#define M_SOF3  0xC3
#define M_SOF5  0xC5            // NB: codes C4 and CC are NOT SOF markers
#define M_SOF6  0xC6
#define M_SOF7  0xC7
#define M_SOF9  0xC9
#define M_SOF10 0xCA
#define M_SOF11 0xCB
#define M_SOF13 0xCD
#define M_SOF14 0xCE
#define M_SOF15 0xCF
#define M_SOI   0xD8            // Start Of Image (beginning of datastream)
#define M_EOI   0xD9            // End Of Image (end of datastream)
#define M_SOS   0xDA            // Start Of Scan (begins compressed data)
#define M_JFIF  0xE0            // Jfif marker
#define M_EXIF  0xE1            // Exif marker
#define M_COM   0xFE            // COMment 


class IFD;
class IFDEntry;

typedef string tagFunction(const char *_name, IFDEntry *_entry, const char *_units);

struct knowntag
{
  unsigned long tag;
  const char *name;
  tagFunction *func;
  const char *units;
};


class Image_Section{

  friend class Exif_Parser;

 private:
  unsigned char *data;
  unsigned int size;
  unsigned char type;

 public:

  Image_Section();
  //~Image_Section() { if (data) delete [] data; }

  Image_Section(const Image_Section&);
  Image_Section& operator=(const Image_Section&);
};


enum EXIF_ERROR {EXIF_OK=0, EXIF_OPEN_FAILED, EXIF_READ_FAILED, EXIF_WRITE_FAILED, 
		 EXIF_NOT_JPEG,  EXIF_EXTRA_PADDING_BYTES, EXIF_INVALID_MARKER, 
		 EXIF_PREMATURE_FILE_END, EXIF_NO_EXIF, EXIF_UNKNOWN_BYTE_ORDER};


class Exif_Parser {

public: 

  Exif_Parser(const char* fileName);
  ~Exif_Parser();

  EXIF_ERROR processFile();

  static int motorolaOrder;
  static unsigned short Get_UShort(void *Short);
  static unsigned long Get_ULong(void *Long);
  static signed long Get_SLong(void *Long);

  string getErrorName();

  int getIFD0(vector<string> &vector_IFD0_name, vector<string> &vector_IFD0_value);
  int getIFD1(vector<string> &vector_IFD1_name, vector<string> &vector_IFD1_value);
  int getsubIFD(vector<string> &vector_subIFD_name, vector<string> &vector_subIFD_value);
  int getinterIFD(vector<string> &vector_interIFD_name, vector<string> &vector_interIFD_value);
  int getmakerIFD(vector<string> &vector_makerIFD_name, vector<string> &vector_makerIFD_value);

  int  getThumbnail(unsigned char* &thumbPtr, unsigned int &thumbSize);
  void getComments(string &comments);
  void changeComments(const string &newComments);
  EXIF_ERROR writeImageFile(const char* fileName);

  const char* imageFileName;
  
private:

  EXIF_ERROR hasExif();
  EXIF_ERROR getByteOrder();
  void processIFD(IFD *ifd, knowntag *tagTable);
  void processComment();

  EXIF_ERROR exifError;
  ifstream fileStream;

  unsigned char* exifData;
  int exifDataSize;

  unsigned char* thumbnailPtr;
  unsigned thumbnailSize;
  
  unsigned char* imageData;
  int imageDataSize;

  unsigned char* commentData;
  int commentDataSize;
  string commentString;

  vector<Image_Section> imageSections;

  IFD *IFD0;
  IFD *IFD1;
  IFD *subIFD;
  IFD *interIFD;
  IFD *makerIFD;

  knowntag *maker_tags;
  string makerName;

};



#endif
