#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>

#include "ifd.h"
#include "exif_parser.h"

static int BytesPerFormat[] = {0,1,1,2,4,8,1,1,2,4,8,4,8};

IFD::IFD(unsigned char *_dirStart,  unsigned char *_offsetBase, 
	 unsigned _exifLength) {

  dirStart = _dirStart;
  offsetBase = _offsetBase;
  exifLength = _exifLength;

  numEntries = Exif_Parser::Get_UShort(dirStart);

  ifdTable = new IFDEntry *[numEntries];

#define DIR_ENTRY_ADDR(Start, Entry) (Start+2+12*(Entry))

  for (int i=0; i<numEntries; i++){

    int tag, format, numComponents;
    unsigned char * valuePtr;
    int byteCount;
    unsigned char * dirEntry;
    
    dirEntry = DIR_ENTRY_ADDR(dirStart, i);
    tag = Exif_Parser::Get_UShort(dirEntry);
    format = Exif_Parser::Get_UShort(dirEntry+2);
    numComponents = Exif_Parser::Get_ULong(dirEntry+4);

    byteCount = numComponents * BytesPerFormat[format];
       
    if (byteCount > 4){
      unsigned offsetVal;
      offsetVal = Exif_Parser::Get_ULong(dirEntry+8);
      valuePtr = offsetBase+offsetVal;
    }
    else {
      // 4 bytes or less and value is in the dir entry itself
      valuePtr = dirEntry+8;
    }

    IFDEntry *entry = new IFDEntry(tag, format, numComponents, valuePtr, byteCount); 
    ifdTable[i] = entry;

  }

}


IFD::~IFD() {

  if (numEntries) {
    for(int i=0; i<numEntries; i++)
      delete ifdTable[i];
    delete [] ifdTable;
  }
}
