
#include "thumbnailsize.h"


ThumbnailSize::ThumbnailSize(Size value) : mValue(value) {}


ThumbnailSize::ThumbnailSize(const QString& str) {
	QString low=str.lower();
	if (low=="small") {
		mValue=Small;
	} else if (low=="large") {
		mValue=Large;
	} else {
		mValue=Med;
	}
}


int ThumbnailSize::pixelSize() const {
	switch (mValue) {
	case Small:
		return 48;
	case Med:
		return 64;
	default: /* Always Large, but keeps the compiler from complaining */
		return 90;
	}
}


ThumbnailSize::operator const QString&() const {
// Little "hack" to allow returning a reference instead of a new QString
	static QString sizeStr[3]={"small","med","large"};
	return sizeStr[int(mValue)];
}
