#include "camera_fileinfo.h"

Camera_FileInfo::Camera_FileInfo() {


  m_Name = "";
  m_Folder = "";

  m_fileInfoAvailable = false;

  m_Mime = "";
  m_Time = "";
  m_Size = -1;
  m_Width = -1;
  m_Height = -1;
  m_ReadPermissions = -1;
  m_DeletePermissions = -1;
  m_Downloaded = -1;

  //----------------------------

  m_previewInfoAvailable = false;

  m_PreviewMime = "";
  m_PreviewWidth = -1;
  m_PreviewHeight = -1;
  m_PreviewSize = -1;
  m_PreviewDownloaded = -1;

  //----------------------------

  m_audioInfoAvailable = false;

  m_AudioMime = "";
  m_AudioSize = -1;
  m_AudioDownloaded = -1;


}

Camera_FileInfo::Camera_FileInfo(const Camera_FileInfo& fileInfo)
{
    m_Name = QString(fileInfo.m_Name.latin1());
    m_Folder = QString(fileInfo.m_Folder.latin1());

    //----------------------------

    m_fileInfoAvailable = fileInfo.m_fileInfoAvailable;

    m_Mime = QString(fileInfo.m_Mime.latin1());
    m_Time = QString(fileInfo.m_Time.latin1());
    m_Size = fileInfo.m_Size;
    m_Width = fileInfo.m_Width;
    m_Height = fileInfo.m_Height;
    m_ReadPermissions = fileInfo.m_ReadPermissions;
    m_DeletePermissions = fileInfo.m_DeletePermissions;
    m_Downloaded = fileInfo.m_Downloaded;

    //----------------------------

    m_previewInfoAvailable = fileInfo.m_previewInfoAvailable;

    m_PreviewMime = QString(fileInfo.m_PreviewMime.latin1());
    m_PreviewWidth = fileInfo.m_PreviewWidth;
    m_PreviewHeight = fileInfo.m_PreviewHeight;
    m_PreviewSize = fileInfo.m_PreviewSize;
    m_PreviewDownloaded = fileInfo.m_PreviewDownloaded;

    //----------------------------

    m_audioInfoAvailable = fileInfo.m_audioInfoAvailable;

    m_AudioMime = QString(fileInfo.m_AudioMime.latin1());
    m_AudioSize = fileInfo.m_AudioSize;
    m_AudioDownloaded = fileInfo.m_AudioDownloaded;
}


Camera_FileInfo& Camera_FileInfo::operator=(const Camera_FileInfo& fileInfo)
{
    if (this != &fileInfo) {

        m_Name = QString(fileInfo.m_Name.latin1());
        m_Folder = QString(fileInfo.m_Folder.latin1());

        //----------------------------

        m_fileInfoAvailable = fileInfo.m_fileInfoAvailable;

        m_Mime = QString(fileInfo.m_Mime.latin1());
        m_Time = QString(fileInfo.m_Time.latin1());
        m_Size = fileInfo.m_Size;
        m_Width = fileInfo.m_Width;
        m_Height = fileInfo.m_Height;
        m_ReadPermissions = fileInfo.m_ReadPermissions;
        m_DeletePermissions = fileInfo.m_DeletePermissions;
        m_Downloaded = fileInfo.m_Downloaded;

        //----------------------------

        m_previewInfoAvailable = fileInfo.m_previewInfoAvailable;

        m_PreviewMime = QString(fileInfo.m_PreviewMime.latin1());
        m_PreviewWidth = fileInfo.m_PreviewWidth;
        m_PreviewHeight = fileInfo.m_PreviewHeight;
        m_PreviewSize = fileInfo.m_PreviewSize;
        m_PreviewDownloaded = fileInfo.m_PreviewDownloaded;

        //----------------------------

        m_audioInfoAvailable = fileInfo.m_audioInfoAvailable;

        m_AudioMime = QString(fileInfo.m_AudioMime.latin1());
        m_AudioSize = fileInfo.m_AudioSize;
        m_AudioDownloaded = fileInfo.m_AudioDownloaded;
    }

    return *this;
}

void Camera_FileInfo::setName(const QString& name)
{
    m_Name = QString(name.latin1());
}

QString Camera_FileInfo::getName() const
{
    return m_Name;
}

void Camera_FileInfo::setFolder(const QString& folder)
{
    m_Folder = QString(folder.latin1());
}

QString Camera_FileInfo::getFolder() const
{
    return m_Folder;
}

void Camera_FileInfo::setFileInfoAvailable(bool avail)
{
    m_fileInfoAvailable = avail;
}

bool Camera_FileInfo::isFileInfoAvailable()
{
    return m_fileInfoAvailable;
}

void Camera_FileInfo::setMime(const QString& mime)
{
    m_Mime = QString(mime.latin1());
}

QString Camera_FileInfo::getMime() const
{
    return m_Mime;
}

void Camera_FileInfo::setTime(const QString& time)
{
    m_Time = QString(time.latin1());
}

QString Camera_FileInfo::getTime() const
{
    return m_Time;
}

void Camera_FileInfo::setSize(int size)
{
    m_Size = size;
}

int Camera_FileInfo::getSize()
{
    return m_Size;
}

void Camera_FileInfo::setWidth(int width)
{
    m_Width = width;
}

int Camera_FileInfo::getWidth()
{
    return m_Width;
}

void Camera_FileInfo::setHeight(int height)
{
    m_Height = height;
}

int Camera_FileInfo::getHeight()
{
    return m_Height;
}

void Camera_FileInfo::setReadPermissions(int readPerms)
{
    m_ReadPermissions = readPerms;
}

int Camera_FileInfo::getReadPermissions()
{
    return m_ReadPermissions;
}

void Camera_FileInfo::setDeletePermissions(int readPerms)
{
    m_DeletePermissions = readPerms;
}

int Camera_FileInfo::getDeletePermissions()
{
    return m_DeletePermissions;
}


void Camera_FileInfo::setDownloaded(int downloaded)
{
    m_Downloaded = downloaded;
}

int Camera_FileInfo::getDownloaded()
{
    return m_Downloaded;
}

void Camera_FileInfo::setPreviewInfoAvailable(bool avail)
{
    m_previewInfoAvailable = avail;
}

bool Camera_FileInfo::isPreviewInfoAvailable()
{
    return m_previewInfoAvailable;
}

void Camera_FileInfo::setPreviewMime(const QString& mime)
{
    m_PreviewMime = QString(mime.latin1());
}

QString Camera_FileInfo::getPreviewMime() const
{
    return m_PreviewMime;
}

void Camera_FileInfo::setPreviewWidth(int width)
{
    m_PreviewWidth = width;
}

int Camera_FileInfo::getPreviewWidth()
{
    return m_PreviewWidth;
}

void Camera_FileInfo::setPreviewHeight(int height)
{
    m_PreviewHeight = height;
}

int Camera_FileInfo::getPreviewHeight()
{
    return m_PreviewHeight;
}

void Camera_FileInfo::setPreviewSize(int size)
{
    m_PreviewSize = size;
}

int Camera_FileInfo::getPreviewSize()
{
    return m_PreviewSize;
}

void Camera_FileInfo::setPreviewDownloaded(int downloaded)
{
    m_PreviewDownloaded = downloaded;
}

int Camera_FileInfo::getPreviewDownloaded()
{
    return m_PreviewDownloaded;
}

void Camera_FileInfo::setAudioInfoAvailable(bool avail)
{
    m_audioInfoAvailable = avail;
}

bool Camera_FileInfo::isAudioInfoAvailable()
{
    return m_audioInfoAvailable;
}

void Camera_FileInfo::setAudioMime(const QString& mime)
{
    m_AudioMime = QString(mime.latin1());
}

QString Camera_FileInfo::getAudioMime() const
{
    return m_AudioMime;
}

void Camera_FileInfo::setAudioSize(int size)
{
    m_AudioSize = size;
}

int Camera_FileInfo::getAudioSize()
{
    return m_AudioSize;
}


void Camera_FileInfo::setAudioDownloaded(int downloaded)
{
    m_AudioDownloaded = downloaded;
}

int Camera_FileInfo::getAudioDownloaded()
{
    return m_AudioDownloaded;
}
