#ifndef SETUP_BASE_H
#define SETUP_BASE_H

#include <kdialogbase.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class KListView;
class QButtonGroup;
class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QListViewItem;
class QPushButton;
class QRadioButton;
class QFrame;

class Setup_Base : public KDialogBase
{ 
  Q_OBJECT

public:

  Setup_Base( QWidget* parent = 0, const char* name = 0);
  ~Setup_Base();

  
  QFrame* cameraPage;

  QGroupBox* QGroupBox_portSetting;
  QLabel* QTextLabel_portPath;
  QComboBox* QComboBox_portPath;
  QButtonGroup* QButtonGroup_port;
  QRadioButton* QRadioButton_serial;
  QRadioButton* QRadioButton_firewire;
  QRadioButton* QRadioButton_usb;
  QRadioButton* QRadioButton_parallel;
  QPushButton* QPushButton_autoDetect;
  KListView* KListView_cameras;
  
  QFrame* generalPage;

  QLabel* TextLabel;
  QPushButton* QPushButton_browse;
  QComboBox* QComboBox_downloadDir;
  QCheckBox* QCheckBox_connect;
  QCheckBox* QCheckBox_thumbnails;
  QCheckBox* QCheckBox_showAllImages;
  QCheckBox* QCheckBox_hideCameraFolders;


protected slots:

  virtual void slot_autoDetect();
  virtual void slot_setModel(QListViewItem *);
  virtual void slot_setPortPathLabel(int);
  virtual void slot_browse();

  void slot_hideCameraFoldersClicked(bool on);

protected:
  
  QGridLayout* cameraPageLayout;
  QGridLayout* generalPageLayout;
  
};

#endif
