#include "camerafileiteminfo.h"

CameraFileItemInfo::CameraFileItemInfo() {


  m_Name = "";
  m_Folder = "";

  m_fileInfoAvailable = false;

  m_Mime = "";
  m_Time = "";
  m_Size = -1;
  m_Width = -1;
  m_Height = -1;
  m_ReadPermissions = -1;
  m_DeletePermissions = -1;
  m_Downloaded = -1;

  //----------------------------

  m_previewInfoAvailable = false;

  m_PreviewMime = "";
  m_PreviewWidth = -1;
  m_PreviewHeight = -1;
  m_PreviewSize = -1;
  m_PreviewDownloaded = -1;

  //----------------------------

  m_audioInfoAvailable = false;

  m_AudioMime = "";
  m_AudioSize = -1;
  m_AudioDownloaded = -1;


}

CameraFileItemInfo::CameraFileItemInfo(const CameraFileItemInfo& fileInfo)
{
    m_Name = QString(fileInfo.m_Name.latin1());
    m_Folder = QString(fileInfo.m_Folder.latin1());

    //----------------------------

    m_fileInfoAvailable = fileInfo.m_fileInfoAvailable;

    m_Mime = QString(fileInfo.m_Mime.latin1());
    m_Time = QString(fileInfo.m_Time.latin1());
    m_Size = fileInfo.m_Size;
    m_Width = fileInfo.m_Width;
    m_Height = fileInfo.m_Height;
    m_ReadPermissions = fileInfo.m_ReadPermissions;
    m_DeletePermissions = fileInfo.m_DeletePermissions;
    m_Downloaded = fileInfo.m_Downloaded;

    //----------------------------

    m_previewInfoAvailable = fileInfo.m_previewInfoAvailable;

    m_PreviewMime = QString(fileInfo.m_PreviewMime.latin1());
    m_PreviewWidth = fileInfo.m_PreviewWidth;
    m_PreviewHeight = fileInfo.m_PreviewHeight;
    m_PreviewSize = fileInfo.m_PreviewSize;
    m_PreviewDownloaded = fileInfo.m_PreviewDownloaded;

    //----------------------------

    m_audioInfoAvailable = fileInfo.m_audioInfoAvailable;

    m_AudioMime = QString(fileInfo.m_AudioMime.latin1());
    m_AudioSize = fileInfo.m_AudioSize;
    m_AudioDownloaded = fileInfo.m_AudioDownloaded;
}


CameraFileItemInfo& CameraFileItemInfo::operator=(const CameraFileItemInfo& fileInfo)
{
    if (this != &fileInfo) {

        m_Name = QString(fileInfo.m_Name.latin1());
        m_Folder = QString(fileInfo.m_Folder.latin1());

        //----------------------------

        m_fileInfoAvailable = fileInfo.m_fileInfoAvailable;

        m_Mime = QString(fileInfo.m_Mime.latin1());
        m_Time = QString(fileInfo.m_Time.latin1());
        m_Size = fileInfo.m_Size;
        m_Width = fileInfo.m_Width;
        m_Height = fileInfo.m_Height;
        m_ReadPermissions = fileInfo.m_ReadPermissions;
        m_DeletePermissions = fileInfo.m_DeletePermissions;
        m_Downloaded = fileInfo.m_Downloaded;

        //----------------------------

        m_previewInfoAvailable = fileInfo.m_previewInfoAvailable;

        m_PreviewMime = QString(fileInfo.m_PreviewMime.latin1());
        m_PreviewWidth = fileInfo.m_PreviewWidth;
        m_PreviewHeight = fileInfo.m_PreviewHeight;
        m_PreviewSize = fileInfo.m_PreviewSize;
        m_PreviewDownloaded = fileInfo.m_PreviewDownloaded;

        //----------------------------

        m_audioInfoAvailable = fileInfo.m_audioInfoAvailable;

        m_AudioMime = QString(fileInfo.m_AudioMime.latin1());
        m_AudioSize = fileInfo.m_AudioSize;
        m_AudioDownloaded = fileInfo.m_AudioDownloaded;
    }

    return *this;
}

void CameraFileItemInfo::setName(const QString& name)
{
    m_Name = QString(name.latin1());
}

QString CameraFileItemInfo::getName() const
{
    return m_Name;
}

void CameraFileItemInfo::setFolder(const QString& folder)
{
    m_Folder = QString(folder.latin1());
}

QString CameraFileItemInfo::getFolder() const
{
    return m_Folder;
}

void CameraFileItemInfo::setFileInfoAvailable(bool avail)
{
    m_fileInfoAvailable = avail;
}

bool CameraFileItemInfo::isFileInfoAvailable()
{
    return m_fileInfoAvailable;
}

void CameraFileItemInfo::setMime(const QString& mime)
{
    m_Mime = QString(mime.latin1());
}

QString CameraFileItemInfo::getMime() const
{
    return m_Mime;
}

void CameraFileItemInfo::setTime(const QString& time)
{
    m_Time = QString(time.latin1());
}

QString CameraFileItemInfo::getTime() const
{
    return m_Time;
}

void CameraFileItemInfo::setSize(int size)
{
    m_Size = size;
}

int CameraFileItemInfo::getSize()
{
    return m_Size;
}

void CameraFileItemInfo::setWidth(int width)
{
    m_Width = width;
}

int CameraFileItemInfo::getWidth()
{
    return m_Width;
}

void CameraFileItemInfo::setHeight(int height)
{
    m_Height = height;
}

int CameraFileItemInfo::getHeight()
{
    return m_Height;
}

void CameraFileItemInfo::setReadPermissions(int readPerms)
{
    m_ReadPermissions = readPerms;
}

int CameraFileItemInfo::getReadPermissions()
{
    return m_ReadPermissions;
}

void CameraFileItemInfo::setDeletePermissions(int readPerms)
{
    m_DeletePermissions = readPerms;
}

int CameraFileItemInfo::getDeletePermissions()
{
    return m_DeletePermissions;
}


void CameraFileItemInfo::setDownloaded(int downloaded)
{
    m_Downloaded = downloaded;
}

int CameraFileItemInfo::getDownloaded()
{
    return m_Downloaded;
}

void CameraFileItemInfo::setPreviewInfoAvailable(bool avail)
{
    m_previewInfoAvailable = avail;
}

bool CameraFileItemInfo::isPreviewInfoAvailable()
{
    return m_previewInfoAvailable;
}

void CameraFileItemInfo::setPreviewMime(const QString& mime)
{
    m_PreviewMime = QString(mime.latin1());
}

QString CameraFileItemInfo::getPreviewMime() const
{
    return m_PreviewMime;
}

void CameraFileItemInfo::setPreviewWidth(int width)
{
    m_PreviewWidth = width;
}

int CameraFileItemInfo::getPreviewWidth()
{
    return m_PreviewWidth;
}

void CameraFileItemInfo::setPreviewHeight(int height)
{
    m_PreviewHeight = height;
}

int CameraFileItemInfo::getPreviewHeight()
{
    return m_PreviewHeight;
}

void CameraFileItemInfo::setPreviewSize(int size)
{
    m_PreviewSize = size;
}

int CameraFileItemInfo::getPreviewSize()
{
    return m_PreviewSize;
}

void CameraFileItemInfo::setPreviewDownloaded(int downloaded)
{
    m_PreviewDownloaded = downloaded;
}

int CameraFileItemInfo::getPreviewDownloaded()
{
    return m_PreviewDownloaded;
}

void CameraFileItemInfo::setAudioInfoAvailable(bool avail)
{
    m_audioInfoAvailable = avail;
}

bool CameraFileItemInfo::isAudioInfoAvailable()
{
    return m_audioInfoAvailable;
}

void CameraFileItemInfo::setAudioMime(const QString& mime)
{
    m_AudioMime = QString(mime.latin1());
}

QString CameraFileItemInfo::getAudioMime() const
{
    return m_AudioMime;
}

void CameraFileItemInfo::setAudioSize(int size)
{
    m_AudioSize = size;
}

int CameraFileItemInfo::getAudioSize()
{
    return m_AudioSize;
}


void CameraFileItemInfo::setAudioDownloaded(int downloaded)
{
    m_AudioDownloaded = downloaded;
}

int CameraFileItemInfo::getAudioDownloaded()
{
    return m_AudioDownloaded;
}
