/***************************************************************************
                          imageviewer.h  -  description
                             -------------------
    begin                : Tue Jan 15 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEVIEWER_H
#define IMAGEVIEWER_H

#include <qscrollview.h>

class QString;
class QPixmap;
class QImage;
class QPainter;
class QResizeEvent;

/**
 *@author Renchi Raju
 */

class ImageViewer : public QScrollView  {

public:

    ImageViewer(QWidget* parent=0, const char* name = 0,
                 WFlags fl = WDestructiveClose );
    ~ImageViewer();
    void loadImage(QString filePath);

private:

    QPixmap pixmap;
    QImage image;
    void drawContents(QPainter* painter,int clipx,int clipy,int clipw,int cliph);

    void resizeEvent(QResizeEvent* event);
    bool initialResize;

};

#endif
