#include <qtabwidget.h>
#include <klocale.h>

#include "setupcamera.h"
#include "setupgeneral.h"

#include "setup.h"

Setup::Setup(QWidget* parent, const char* name)
    : KDialogBase(parent, name, true, i18n("Setup"),
                  Ok|Apply|Cancel, Ok, true )
{

    QTabWidget *tabWidget = new QTabWidget(this);
    setMainWidget(tabWidget);

    mCameraPage = new SetupCamera(tabWidget);
    tabWidget->insertTab(mCameraPage, i18n("Camera Settings"));

    mGeneralPage = new SetupGeneral(tabWidget);
    tabWidget->insertTab(mGeneralPage, i18n("General Settings"));


    resize( 484, 600 );

    connect(this, SIGNAL(okClicked()),
            this, SLOT(slot_ok()) );
    connect(this, SIGNAL(cancelClicked()),
            this, SLOT(slot_cancel()) );
    connect(this, SIGNAL(applyClicked()),
            this, SLOT(slot_apply()) );

}

Setup::~Setup()
{

}

void Setup::slot_ok()
{
    mCameraPage->saveSettings();
    mGeneralPage->saveSettings();
}

void Setup::slot_cancel()
{

}

void Setup::slot_apply()
{
    mCameraPage->saveSettings();
    mGeneralPage->saveSettings();
}
