#ifndef SETUPCAMERA_H
#define SETUPCAMERA_H

#include <qwidget.h>
#include <qstringlist.h>
#include <qstring.h>

class QGridLayout;
class KListView;
class QButtonGroup;
class QComboBox;
class QGroupBox;
class QLabel;
class QPushButton;
class QRadioButton;
class QListViewItem;

class Gphoto_Interface;


class SetupCamera : public QWidget {

    Q_OBJECT

public:

    SetupCamera(QWidget *parent, const char* name=0);
    ~SetupCamera();

    void saveSettings();

private:


    Gphoto_Interface *gpInterface;

    QGridLayout*  mLayout;

    QGroupBox*    mPortSettingBox;
    QLabel*       mPortPathLabel;
    QComboBox*    mPortPathComboBox;

    QGroupBox*    mPathSettingBox;
    QLabel*       mPathLabel;
    QComboBox*    mPathComboBox;
    QPushButton*  mPathBrowseButton;

    QButtonGroup* mPortButtonGroup;
    QRadioButton* mSerialRadioButton;
    QRadioButton* mUSBRadioButton;

    QPushButton*  mAutoDetectButton;

    KListView*    mCameraListView;

    QStringList mSupportedSerialPorts;
    QString     mCameraModel;
    QString     mCameraPort;
    QString     mCameraPath;
    QString     mUMSCameraNameActual;
    QString     mUMSCameraNameShown;


private:

    void getCameraList();
    void getPortList();
    void loadSettings();

private slots:

    void slot_autoDetect();
    void slot_setModel(QListViewItem *);
    void slot_setPort(int portType);

};

#endif
