#include <qimage.h>
#include <qcolor.h>

#include "thumbnailmt.h"
#include <kdebug.h>

ThumbnailMT::ThumbnailMT() {

}

ThumbnailMT::ThumbnailMT(const QImage& image) {

	mImage = image.copy();

}

ThumbnailMT::~ThumbnailMT() {

}

ThumbnailMT::ThumbnailMT(const ThumbnailMT& thumb) {

  if (this != &thumb)
	mImage = thumb.mImage.copy();

}


ThumbnailMT& ThumbnailMT::operator=(const ThumbnailMT& thumb) {


  if (this != &thumb) {

      mImage = thumb.mImage.copy();

  }

  return *this;

}

bool ThumbnailMT::isNull()
{
    return mImage.isNull();
}

void ThumbnailMT::fillPixmap(QPixmap& pix) {

   pix.convertFromImage(mImage);

}

void ThumbnailMT::load(const QImage& image)
{
    mImage = image.copy();
}


void ThumbnailMT::load(const QString& fileName)
{
	mImage.load(fileName);
}

void ThumbnailMT::load(const uchar *data, uint size)
{
    mImage.loadFromData(data,size);
}


void ThumbnailMT::scale(const ThumbnailSize& thumbSize)
{
    mImage = mImage.smoothScale(thumbSize.getSizeAsNumber(),
                              thumbSize.getSizeAsNumber(),
                              QImage::ScaleMin);
}

void ThumbnailMT::save(const QString& fileName)
{

    bool result = mImage.save(fileName,"JPEG");
    if (!result)
        kdDebug() << "Error in saving file " << fileName << endl;
}

void ThumbnailMT::dropShadow()
{
    QColor darkColor(48, 48, 48);
    QColor lightColor(215, 215, 215);

    // Right
    for (int y=0; y<mImage.height(); y++)
        mImage.setPixel(mImage.width()-1, y, darkColor.rgb());

    // Bottom
    for (int x=0; x<mImage.width(); x++)
        mImage.setPixel(x, mImage.height()-1, darkColor.rgb());

    // Top
    for (int x=0; x<mImage.width(); x++)
        mImage.setPixel(x, 0, lightColor.rgb());

    // Left
    for (int y=0; y<mImage.height(); y++)
        mImage.setPixel(0, y, lightColor.rgb());


}
