/*
Copyright (c) 2008 Stephen Kelly <steveire@gmail.com>

This library is free software; you can redistribute it and/or modify it
under the terms of the GNU Library General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

#ifndef AKONADI_COLLECTIONCHILDORDERATTRIBUTE_H
#define AKONADI_COLLECTIONCHILDORDERATTRIBUTE_H

#include "akonadi_next_export.h"
#include <akonadi/attribute.h>

// #include <QStringList>

class QStringList;

namespace AkonadiFuture
{

/**
* Holds an ordered list of remoteIds for child collections and items in a model.
* @since 4.3
*/
class AKONADI_NEXT_EXPORT CollectionChildOrderAttribute : public Akonadi::Attribute
{
public:
  /**
  * Creates a new attribute.
  */
  CollectionChildOrderAttribute();

  /**
  * Destructor.
  */
  ~CollectionChildOrderAttribute();

  void setOrderList( QStringList l );

  QStringList orderList();

  /* reimpl */
  QByteArray type() const;
  CollectionChildOrderAttribute* clone() const;
  QByteArray serialized() const;
  void deserialize( const QByteArray &data );

private:
  //@cond PRIVATE
  class Private;
  Private* const d;
  //@endcond
};

}

#endif
