/*
 * This file is part of Krita
 *
 * Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef EXAMPLE_H
#define EXAMPLE_H

#include <kparts/plugin.h>
#include "kis_convolution_filter.h"
#include "kis_matrix.h"
#include "kis_view.h"

class KisView;

// XXX: All these filters are loaded on document creation. A document
// can, theoretically, contain zero or more images of different
// depths. If there are zero images, then closing Krita will crash
// in the destructor.
class KisGaussianBlurFilter : public KisConvolutionConstFilter {
public:
	KisGaussianBlurFilter(KisView * view);
public:
	static inline KisID id() { return KisID("gaussian blur", i18n("Gaussian Blur")); };
        virtual bool supportsPainting() { return true; }
	virtual bool supportsIncrementalPainting() { return true; }
};

class KisSharpenFilter : public KisConvolutionConstFilter {
public:
	KisSharpenFilter(KisView * view);
public:
	static inline KisID id() { return KisID("sharpen", i18n("Sharpen")); };
        virtual bool supportsPainting() { return false; }
	virtual bool supportsIncrementalPainting() { return false; }
};

class KisMeanRemovalFilter : public KisConvolutionConstFilter {
public:
	KisMeanRemovalFilter(KisView * view);
public:
	static inline KisID id() { return KisID("mean removal", i18n("Mean Removal")); };
        virtual bool supportsPainting() { return false; }

};

class KisEmbossLaplascianFilter : public KisConvolutionConstFilter {
public:
	KisEmbossLaplascianFilter(KisView * view);
public:
	static inline KisID id() { return KisID("emboss laplascian", i18n("Emboss Laplascian")); };
        virtual bool supportsPainting() { return false; }

};

class KisEmbossInAllDirectionsFilter : public KisConvolutionConstFilter {
public:
	KisEmbossInAllDirectionsFilter(KisView * view);
public:
	static inline KisID id() { return KisID("emboss all directions", i18n("Emboss in All Directions")); };
        virtual bool supportsPainting() { return false; }

};

class KisEmbossHorizontalVerticalFilter : public KisConvolutionConstFilter {
public:
	KisEmbossHorizontalVerticalFilter(KisView * view);
public:
	static inline KisID id() { return KisID("", i18n("Emboss Horizontal & Vertical")); };
        virtual bool supportsPainting() { return false; }

};

class KisEmbossVerticalFilter : public KisConvolutionConstFilter {
public:
	KisEmbossVerticalFilter(KisView * view);
public:
	static inline KisID id() { return KisID("emboss vertical only", i18n("Emboss Vertical Only")); };
        virtual bool supportsPainting() { return false; }

};

class KisEmbossHorizontalFilter : public KisConvolutionConstFilter {
public:
	KisEmbossHorizontalFilter(KisView * view);
public:
	static inline KisID id() { return KisID("emboss horizontal only", i18n("Emboss Horizontal Only")); };
        virtual bool supportsPainting() { return false; }

};

class KisEmbossDiagonalFilter : public KisConvolutionConstFilter {
public:
	KisEmbossDiagonalFilter(KisView * view);
public:
	static inline KisID id() { return KisID("emboss diagonal", i18n("Emboss Diagonal")); };
        virtual bool supportsPainting() { return false; }

};

class KisTopEdgeDetectionFilter : public KisConvolutionConstFilter {
public:
	KisTopEdgeDetectionFilter(KisView * view);
public:
	static inline KisID id() { return KisID("top edge detections", i18n("Top Edge Detection")); };
        virtual bool supportsPainting() { return false; }

};

class KisRightEdgeDetectionFilter : public KisConvolutionConstFilter {
public:
	KisRightEdgeDetectionFilter(KisView * view);
public:
	static inline KisID id() { return KisID("right edge detections", i18n("Right Edge Detection")); };
        virtual bool supportsPainting() { return false; }

};

class KisBottomEdgeDetectionFilter : public KisConvolutionConstFilter {
public:
	KisBottomEdgeDetectionFilter(KisView * view);
public:
	static inline KisID id() { return KisID("bottom edge detections", i18n("Bottom Edge Detection")); };
        virtual bool supportsPainting() { return false; }

};

class KisLeftEdgeDetectionFilter : public KisConvolutionConstFilter {
public:
	KisLeftEdgeDetectionFilter(KisView * view);
public:
	static inline KisID id() { return KisID("left edge detections", i18n("Left Edge Detection")); };
        virtual bool supportsPainting() { return false; }

};


class KritaConvolutionFilters : public KParts::Plugin
{
public:
	KritaConvolutionFilters(QObject *parent, const char *name, const QStringList &);
	virtual ~KritaConvolutionFilters();
};

#endif
