/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  nicksonline.h  -  description
  begin:     Sam Aug 31 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com

  $Id: nicksonline.h,v 1.3 2003/02/17 14:00:22 eisfuchs Exp $
*/

#ifndef NICKSONLINE_H
#define NICKSONLINE_H

#include <qvbox.h>

#include <klistview.h>

/*
  @author Dario Abatianni
*/

class NicksOnline : public QVBox
{
  Q_OBJECT

  public: 
    NicksOnline(QSize& newSize);
    ~NicksOnline();

  signals:
    void editClicked();
    void doubleClicked(QListViewItem* item);
    void closeClicked(QSize size);

  public slots:
    void setOnlineList(QStringList list);
    void closeButton();
    
  protected slots:
    void processDoubleClick(QListViewItem* item);

  protected:
    void closeEvent(QCloseEvent* ce);

    KListView* nickListView;
};

#endif
